/* $Id: com_test.c,v 1.2 2001/02/04 12:19:00 rsmith Exp $
 * -*- c -*-
 * This file is a test program for the comm module.
 * Copyright (C) 2001  R.F. Smith <rsmith@xs4all.nl>
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this code; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * $Log: com_test.c,v $
 * Revision 1.2  2001/02/04 12:19:00  rsmith
 * Added `delim' to call of comm_read_text.
 *
 * Revision 1.1  2001/02/04 10:26:50  rsmith
 * Initial revision
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "comm.h"

#ifndef NULL
#define NULL (void*)0
#endif

#ifndef RETURN_IF_FAIL
#define RETURN_IF_FAIL(test) if (!(test)) return
#endif

#ifndef RETURN_VAL_IF_FAIL
#define RETURN_VAL_IF_FAIL(test,val) if (!(test)) return ((val))
#endif

static int int_msg (char *str);
static int uint_msg (char *str);
static int dbl_msg (char *str);
static int quit_msg (char *str);

tcomm_t msg[] = 
{
  {"int", int_msg},
  {"uint", uint_msg},
  {"dbl", dbl_msg},
  {"quit", quit_msg}
};

int out;

int main (int argc, char *argv[])
{
  int rc;
  int in = fileno(stdin);
  out = fileno(stdout);
  printf ("input a message: int, uint, dbl, quit\n");

  while (1)
    {
      rc = comm_read_text (in, "\n", 4, msg);
      if (rc == -3)
        {
          printf ("unknown message.\n\n");
        }
      else if (rc < 0)
        {
          printf ("error %d\n", rc);
          return 2;
        }
    }
  return 0;
}

static int 
int_msg (char *str)
{
  int rc;
  int i;
  rc = comm_get_int (&str, &i);
  if (rc == 0)
    {
      comm_write_text (out, "int_msg", "read %i\n\n", i);
    }
  else
    {
      comm_write_text (out, "int_msg", "error %d\n\n", rc);
    }
  return 0;
}

static int 
uint_msg (char *str)
{
  int rc;
  unsigned u;
  rc = comm_get_uint (&str, &u);
  if (rc == 0)
    {
      comm_write_text (out, "uint_msg", "read %u\n\n", u);
    }
  else
    {
      comm_write_text (out, "uint_msg", "error %d\n\n", rc);
    }
  return 0;
}

static int 
dbl_msg (char *str)
{
  int rc;
  double d;
  rc = comm_get_dbl (&str, &d);
  if (rc == 0)
    {
      comm_write_text (out, "dbl_msg", "read %g\n\n", d);
    }
  else
    {
      comm_write_text (out, "dbl_msg", "error %d\n\n", rc);
    }
  return 0;
}

static int 
quit_msg (char *str)
{
  exit (0);
  return 0;
}


/* EOF $RCSfile: com_test.c,v $ */
