/*
This is part of the audio CD player library
Copyright (C)1998 Tony Arcieri

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.
*/

#include <cdaudio.h>
#include <config.h>
#include <sys/ioctl.h>
#include <sys/types.h>

#ifdef HAVE_LINUX_CDROM_H
#include <linux/cdrom.h>
#else
#ifdef HAVE_SUNDEV_SRREG_H
#include <sundev/srreg.h>
#else
#error Cannot locate a CD-ROM header file for your system
#endif
#endif

#ifdef HAVE_LINUX_UCDROM_H
#include <linux/ucdrom.h>
#endif

int
cd_changer_select_disc(int cd_desc, int disc)
{
   if(ioctl(cd_desc, CDROM_SELECT_DISC, disc) < 0)
     return -1;
   
   return 0;
}

int
cd_changer_slots(int cd_desc)
{
   int slots;

#ifdef CDROM_CHANGER_NSLOTS
   if((slots = ioctl(cd_desc, CDROM_CHANGER_NSLOTS)) < 0)
     slots = 1;
   
   return slots;
#else
   return 1;
#endif
}

int
cd_changer_stat(int cd_desc, struct disc_changer *changer)
{
   int discindex;
   struct disc_info disc;
   struct disc_data data;
   
   changer->changer_slots = cd_changer_slots(cd_desc);
   
   for(discindex = 0; discindex < changer->changer_slots; discindex++) {
      cd_changer_select_disc(cd_desc, discindex);
      
      cd_stat(cd_desc, &disc);
      cddb_read_disc_data(cd_desc, &data);
      
      changer->changer_disc[discindex].disc_status = disc.disc_status;
      changer->changer_disc[discindex].disc_length.minutes = disc.disc_length.minutes;
      changer->changer_disc[discindex].disc_length.seconds = disc.disc_length.seconds;
      changer->changer_disc[discindex].disc_totaltracks = disc.disc_totaltracks;
      changer->changer_disc[discindex].disc_id = data.data_id;
      if(data.data_artist[strlen(data.data_artist) - 1] == ' ')
	snprintf(changer->changer_disc[discindex].disc_info, 128, "%s/ %s", data.data_artist, data.data_title);
      else
	snprintf(changer->changer_disc[discindex].disc_info, 128, "%s / %s", data.data_artist, data.data_title);
   }
   
   return 0;
}
