/* Output from p2c, the Pascal-to-C translator */
/* From input file "ptetra.p" */


#include <p2c/p2c.h>


/*
 * Demonstrate a rotating translating tetrahedron.
 */

/*
        Vogle Pascal header file for Sun Pascal

        link with:

        pc progname.p -lvogle -lsuntool -lsunwindow -lpixrect -lm

*/

/* Standard Colour Indices */

#define BLACK           0
#define RED             1
#define GREEN           2
#define YELLOW          3
#define BLUE            4
#define MAGENTA         5
#define CYAN            6
#define WHITE           7

/* Maximum number of vertices in a polygon */
#define MAXVERTS        128
/* Maximum length of a string type */
#define MAXSTRINGLEN    255
/* Maximum number of "curve" geometries (for curven) */
#define MAXCURVEN       200


/* The type of stings passed to various VOGLE routines... */
typedef Char string_t[MAXSTRINGLEN + 1];


/* For getmatrix and loadmatrix etc, etc... */
typedef float Matrix44_t[4][4];
typedef float Matrix43_t[4][3];

/* For Poly and Poly2 .... */
typedef float Coord2[2];
typedef float Coord3[3];
typedef float Coord4[4];
typedef Coord2 Poly2_array_t[MAXVERTS];
typedef Coord3 Poly3_array_t[MAXVERTS];

/* For Curven....*/
typedef float GeomMat_t[MAXCURVEN][3];

/* Device routines */


extern Void Vinit PP((Char *device));

extern Void Vexit PV();

extern Void Voutput PP((Char *path));

extern Void VnewDev PP((Char *device));

extern Void VgetDev PP((Char *device));

extern long GetDepth PV();

extern Void VsetFlush PP((int yesno));

extern Void Vflush PV();

/* Routines for Setting Up Windows */
extern Void PrefPosition PP((long x, long y));

extern Void PrefSize PP((long width, long height));

/* General routines */
extern Void Clear PV();

extern Void Color PP((long col));

extern Void MapColor PP((long indx, long red, long green, long blue));

extern Void Clipping PP((int on));

extern long GetKey PV();

extern long CheckKey PV();

extern long GetString PP((long bcol, Char *string));

extern long Locator PP((double *xaddr, double *yaddr));

extern long Slocator PP((double *xaddr, double *yaddr));

/* Viewport routines */
extern Void ViewPort PP((double left, double right, double bottom, double top));

extern Void PushViewPort PV();

extern Void PopViewPort PV();

extern Void GetViewPort PP((double *left, double *right, double *bottom,
			    double *top));

/* Getting the aspect details */
extern double GetAspect PV();

extern Void GetFactors PP((double *w, double *h));

extern Void GetDisplaySize PP((double *w, double *h));

/* Attribute stack routines */
extern Void PushAttributes PV();

extern Void PopAttributes PV();

/* Projection routines */
extern Void Ortho PP((double left, double right, double bottom, double top,
		      double near_, double far_));

extern Void Ortho2 PP((double left, double right, double bottom, double top));

extern Void Perspective PP((double fov, double aspect, double near_,
			    double far_));

extern Void Window PP((double left, double right, double bottom, double top,
		       double near_, double far_));

/* Matrix stack routines */
extern Void PushMatrix PV();

extern Void PopMatrix PV();

/* Viewpoint routines */
extern Void PolarView PP((double distance, double azimuth, double incidence,
			  double twist));

extern Void Up PP((double x, double y, double z));

extern Void LookAt PP((double vx, double vy, double vz, double px, double py,
		       double pz, double twist));

/* Moving routines */
extern Void Move PP((double x, double y, double z));

extern Void Rmove PP((double dx, double dy, double dz));

extern Void Move2 PP((double x, double y));

extern Void Rmove2 PP((double dx, double dy));

extern Void Smove2 PP((double x, double y));

extern Void Rsmove2 PP((double dx, double dy));

/* Drawing routines */
extern Void SetDash PP((double d));

extern Void LineStyle PP((Char *str));

extern Void Draw PP((double x, double y, double z));

extern Void Rdraw PP((double dx, double dy, double dz));

extern Void Draw2 PP((double x, double y));

extern Void Rdraw2 PP((double dx, double dy));

extern Void Sdraw2 PP((double x, double y));

extern Void Rsdraw2 PP((double dx, double dy));

/* Arcs and circles */
extern Void CirclePrecision PP((long nsegs));

extern Void Arc PP((double x, double y, double radius, double start_angle,
		    double end_angle));

extern Void Sector PP((double x, double y, double radius, double start_angle,
		       double end_angle));

extern Void Circle PP((double x, double y, double radius));

/* Curve routines */
extern Void CurveBasis PP((float (*basis)[4]));

extern Void CurvePrecision PP((long nsegs));

extern Void Rcurve PP((float (*geom)[4]));

extern Void Curve PP((float (*geom)[3]));

extern Void Curven PP((long n, float (*geom)[3]));

/* Rectangles and general polygon routines */
extern Void Rect PP((double x1, double y1, double x2, double y2));

extern Void PolyFill PP((int on));

extern Void PolyHatch PP((int on));

extern Void HatchAng PP((double angle));

extern Void HatchPitch PP((double pitch));

extern Void Poly2 PP((long n, Coord2 *points));

extern Void Poly PP((long n, Coord3 *points));

extern Void MakePoly PV();

extern Void ClosePoly PV();

extern Void BackFace PP((int onoff));

extern Void BackFaceDir PP((int clockwise));

/* Text routines */
extern Void Font PP((Char *fontname));

extern long NumChars PV();

extern Void TextSize PP((double width, double height));

extern Void TextAng PP((double angle));

extern Void FixedWidth PP((int on));

extern Void CenterText PP((int on));

extern Void TextJustify PP((long val));

extern Void LeftJustify PV();

extern Void RightJustify PV();

extern Void TopJustify PV();

extern Void BottomJustify PV();

extern Void XcenterText PV();

extern Void YcenterText PV();

extern Void GetCharSize PP((int c, double *width, double *height));

extern Void GetFontSize PP((double *width, double *height));

extern Void DrawChar PP((int c));

extern Void DrawStr PP((Char *str));

extern Void StrLength PP((Char *str));

extern Void BoxText PP((double x, double y, double l, double h, Char *s));

extern Void BoxFit PP((double l, double h, long nchars));

/* Transformation routines */
extern Void Translate PP((double x, double y, double z));

extern Void Scale PP((double x, double y, double z));

extern Void Rotate PP((double angle, int axis));

/* Patch routines */
extern Void PatchBasis PP((float (*tbasis)[4], float (*ubasis)[4]));

extern Void PatchPrecision PP((long tseg, long useg));

extern Void PatchCurves PP((long nt, long nu));

extern Void Rpatch PP((float (*gx)[4], float (*gy)[4], float (*gz)[4],
		       float (*gw)[4]));

extern Void Patch PP((float (*gx)[4], float (*gy)[4], float (*gz)[4]));

/* Point routines */
extern Void Point PP((double x, double y, double z));

extern Void Point2 PP((double x, double y));

/* Object routines */
extern Void MakeObj PP((long n));

extern Void CloseObj PV();

extern long GenObj PV();

extern long GetOpenobj PV();

extern Void CallObj PP((long n));

extern long IsObj PP((long n));

extern long DelObj PP((long n));

extern Void LoadObj PP((long n, Char *filename));

extern Void SaveObj PP((long n, Char *filename));

/* Double Buffering */
extern long BackBuffer PV();

extern Void FrontBuffer PV();

extern Void SwapBuffers PV();

/* Position routines */
extern Void GetGp PP((double *x, double *y, double *z));

extern Void GetGpT PP((double *x, double *y, double *z, double *w));

extern Void GetGp2 PP((double *x, double *y));

extern Void SgetGp2 PP((double *x, double *y));


#define TETRAHEDRON     1
#define NSIDES          3
#define NFACES          4
#define NPNTS           4


Static double pnts[NPNTS][3];
Static long faces[NFACES][NSIDES];
Static long colface[4];

Static string_t device, dev;
Static long i;
Static double rotval, drotval, zeye, R, tx, tz;
Static boolean do_backface, do_backface_dir, do_fill;
Static long c;


Static Void init()
{
  rotval = 0.0;
  drotval = 5.0;
  zeye = 5.0;
  R = 1.6;
  tx = 0.0;
  tz = R;
  do_backface = false;
  do_backface_dir = false;
  do_fill = false;
  pnts[0][0] = -0.5;
  pnts[0][1] = 0.866;
  pnts[0][2] = -0.667;
  pnts[1][0] = -0.5;
  pnts[1][1] = -0.866;
  pnts[1][2] = -0.667;
  pnts[2][0] = 1.0;
  pnts[2][1] = 0.0;
  pnts[2][2] = -0.667;
  pnts[3][0] = 0.0;
  pnts[3][1] = 0.0;
  pnts[3][2] = 1.334;

  faces[0][0] = 3;
  faces[0][1] = 2;
  faces[0][2] = 1;
  faces[1][0] = 1;
  faces[1][1] = 2;
  faces[1][2] = 4;
  faces[2][0] = 2;
  faces[2][1] = 3;
  faces[2][2] = 4;
  faces[3][0] = 3;
  faces[3][1] = 1;
  faces[3][2] = 4;

  colface[0] = GREEN;
  colface[1] = YELLOW;
  colface[2] = CYAN;
  colface[3] = MAGENTA;
}


/*
 * maketheobject
 *
 *generate a tetraedron as a series of move draws
 */
Static Void maketheobject()
{
  long i, j;
  double x, y, z;

  MakeObj((long)TETRAHEDRON);

  for (i = 0; i < NFACES; i++) {
    Color(colface[i]);
    MakePoly();
    x = pnts[faces[i][0] - 1][0];
    y = pnts[faces[i][0] - 1][1];
    z = pnts[faces[i][0] - 1][2];
    Move(x, y, z);
    for (j = 1; j < NSIDES; j++) {
      x = pnts[faces[i][j] - 1][0];
      y = pnts[faces[i][j] - 1][1];
      z = pnts[faces[i][j] - 1][2];
      Draw(x, y, z);
    }
    ClosePoly();
  }

  CloseObj();
}


main(argc, argv)
int argc;
Char *argv[];
{
  PASCAL_MAIN(argc, argv);
  init();
  PrefSize(400L, 400L);

  Vinit(device);   /* set up device */

  do_fill = true;
  do_backface = true;
  do_backface_dir = true;

  Font("small");

  /*
   * Make the tetrahedral object
   */
  maketheobject();

  /*
   * See what to do with the thingo...
   */
  PolyFill(do_fill);
  BackFace(do_backface);
  BackFaceDir(do_backface_dir);

  /*
   * set up a perspective projection with a field of view of
   * 40.0 degrees, aspect ratio of 1.0, near clipping plane 0.1,
   * and the far clipping plane at 1000.0.
   */
  Perspective(40.0, 1.0, 0.001, 15.0);
  LookAt(0.0, 0.0, zeye, 0.0, 0.0, 0.0, 0.0);

  /*
   * Setup drawing into the backbuffer....
   */

  if (BackBuffer() < 0) {
    VgetDev(dev);
    Vexit();
/* p2c: ptetra.p, line 346:
 * Warning: Expected an expression, found a comma [227] */
    printf("%12dThe device %s can't support doublebuffering\n", 0, dev);
    _Escape(0);
  }

  do {
    for (i = 0; i <= 72; i++) {
      rotval = i * drotval;
      Color((long)BLACK);
      Clear();

      /*
       * Rotate the whole scene...(this acumulates - hence
       * drotval)
       */
      Rotate(drotval * 0.1, 'x');
      Rotate(drotval * 0.1, 'z');

      Color((long)RED);
      PushMatrix();
      PolyFill(false);
      Rotate(90.0, 'x');
      Circle(0.0, 0.0, R);
      PolyFill(do_fill);
      PopMatrix();

      Color((long)BLUE);
      Move(0.0, 0.0, 0.0);
      Draw(tx, 0.0, tz);

      /*
       * Remember! The order of the transformations is
       * the reverse of what is specified here in between
       * the pushmatrix and the popmatrix. These ones don't
       * accumulate because of the push and pop.
       */
      PushMatrix();
      Translate(tx, 0.0, tz);
      Rotate(rotval, 'x');
      Rotate(rotval, 'y');
      Rotate(rotval, 'z');
      Scale(0.4, 0.4, 0.4);
      CallObj((long)TETRAHEDRON);
      PopMatrix();

      tz = R * cos(rotval * 3.1415926535 / 180);
      tx = R * sin(rotval * 3.1415926535 / 180);

      SwapBuffers();

      c = CheckKey();
      if (c == 'b') {
	do_backface = !do_backface;
	BackFace(do_backface);
      } else if (c == 'd') {
	do_backface_dir = !do_backface_dir;
	BackFaceDir(do_backface_dir);
      } else if (c == 'f') {
	do_fill = !do_fill;
	PolyFill(do_fill);
      } else if (c != 0) {
	Vexit();
	_Escape(0);
      }
    }

  } while (true);

  exit(EXIT_SUCCESS);
}



/* End. */
