/* Output from p2c, the Pascal-to-C translator */
/* From input file "ppoly.p" */


#include <p2c/p2c.h>


/*
        Vogle Pascal header file for Sun Pascal

        link with:

        pc progname.p -lvogle -lsuntool -lsunwindow -lpixrect -lm

*/

/* Standard Colour Indices */

#define BLACK           0
#define RED             1
#define GREEN           2
#define YELLOW          3
#define BLUE            4
#define MAGENTA         5
#define CYAN            6
#define WHITE           7

/* Maximum number of vertices in a polygon */
#define MAXVERTS        128
/* Maximum length of a string type */
#define MAXSTRINGLEN    255
/* Maximum number of "curve" geometries (for curven) */
#define MAXCURVEN       200


/* The type of stings passed to various VOGLE routines... */
typedef Char string_t[MAXSTRINGLEN + 1];


/* For getmatrix and loadmatrix etc, etc... */
typedef float Matrix44_t[4][4];
typedef float Matrix43_t[4][3];

/* For Poly and Poly2 .... */
typedef float Coord2[2];
typedef float Coord3[3];
typedef float Coord4[4];
typedef Coord2 Poly2_array_t[MAXVERTS];
typedef Coord3 Poly3_array_t[MAXVERTS];

/* For Curven....*/
typedef float GeomMat_t[MAXCURVEN][3];

/* Device routines */


extern Void Vinit PP((Char *device));

extern Void Vexit PV();

extern Void Voutput PP((Char *path));

extern Void VnewDev PP((Char *device));

extern Void VgetDev PP((Char *device));

extern long GetDepth PV();

extern Void VsetFlush PP((int yesno));

extern Void Vflush PV();

/* Routines for Setting Up Windows */
extern Void PrefPosition PP((long x, long y));

extern Void PrefSize PP((long width, long height));

/* General routines */
extern Void Clear PV();

extern Void Color PP((long col));

extern Void MapColor PP((long indx, long red, long green, long blue));

extern Void Clipping PP((int on));

extern long GetKey PV();

extern long CheckKey PV();

extern long GetString PP((long bcol, Char *string));

extern long Locator PP((double *xaddr, double *yaddr));

extern long Slocator PP((double *xaddr, double *yaddr));

/* Viewport routines */
extern Void ViewPort PP((double left, double right, double bottom, double top));

extern Void PushViewPort PV();

extern Void PopViewPort PV();

extern Void GetViewPort PP((double *left, double *right, double *bottom,
			    double *top));

/* Getting the aspect details */
extern double GetAspect PV();

extern Void GetFactors PP((double *w, double *h));

extern Void GetDisplaySize PP((double *w, double *h));

/* Attribute stack routines */
extern Void PushAttributes PV();

extern Void PopAttributes PV();

/* Projection routines */
extern Void Ortho PP((double left, double right, double bottom, double top,
		      double near_, double far_));

extern Void Ortho2 PP((double left, double right, double bottom, double top));

extern Void Perspective PP((double fov, double aspect, double near_,
			    double far_));

extern Void Window PP((double left, double right, double bottom, double top,
		       double near_, double far_));

/* Matrix stack routines */
extern Void PushMatrix PV();

extern Void PopMatrix PV();

/* Viewpoint routines */
extern Void PolarView PP((double distance, double azimuth, double incidence,
			  double twist));

extern Void Up PP((double x, double y, double z));

extern Void LookAt PP((double vx, double vy, double vz, double px, double py,
		       double pz, double twist));

/* Moving routines */
extern Void Move PP((double x, double y, double z));

extern Void Rmove PP((double dx, double dy, double dz));

extern Void Move2 PP((double x, double y));

extern Void Rmove2 PP((double dx, double dy));

extern Void Smove2 PP((double x, double y));

extern Void Rsmove2 PP((double dx, double dy));

/* Drawing routines */
extern Void SetDash PP((double d));

extern Void LineStyle PP((Char *str));

extern Void Draw PP((double x, double y, double z));

extern Void Rdraw PP((double dx, double dy, double dz));

extern Void Draw2 PP((double x, double y));

extern Void Rdraw2 PP((double dx, double dy));

extern Void Sdraw2 PP((double x, double y));

extern Void Rsdraw2 PP((double dx, double dy));

/* Arcs and circles */
extern Void CirclePrecision PP((long nsegs));

extern Void Arc PP((double x, double y, double radius, double start_angle,
		    double end_angle));

extern Void Sector PP((double x, double y, double radius, double start_angle,
		       double end_angle));

extern Void Circle PP((double x, double y, double radius));

/* Curve routines */
extern Void CurveBasis PP((float (*basis)[4]));

extern Void CurvePrecision PP((long nsegs));

extern Void Rcurve PP((float (*geom)[4]));

extern Void Curve PP((float (*geom)[3]));

extern Void Curven PP((long n, float (*geom)[3]));

/* Rectangles and general polygon routines */
extern Void Rect PP((double x1, double y1, double x2, double y2));

extern Void PolyFill PP((int on));

extern Void PolyHatch PP((int on));

extern Void HatchAng PP((double angle));

extern Void HatchPitch PP((double pitch));

extern Void Poly2 PP((long n, Coord2 *points));

extern Void Poly PP((long n, Coord3 *points));

extern Void MakePoly PV();

extern Void ClosePoly PV();

extern Void BackFace PP((int onoff));

extern Void BackFaceDir PP((int clockwise));

/* Text routines */
extern Void Font PP((Char *fontname));

extern long NumChars PV();

extern Void TextSize PP((double width, double height));

extern Void TextAng PP((double angle));

extern Void FixedWidth PP((int on));

extern Void CenterText PP((int on));

extern Void TextJustify PP((long val));

extern Void LeftJustify PV();

extern Void RightJustify PV();

extern Void TopJustify PV();

extern Void BottomJustify PV();

extern Void XcenterText PV();

extern Void YcenterText PV();

extern Void GetCharSize PP((int c, double *width, double *height));

extern Void GetFontSize PP((double *width, double *height));

extern Void DrawChar PP((int c));

extern Void DrawStr PP((Char *str));

extern Void StrLength PP((Char *str));

extern Void BoxText PP((double x, double y, double l, double h, Char *s));

extern Void BoxFit PP((double l, double h, long nchars));

/* Transformation routines */
extern Void Translate PP((double x, double y, double z));

extern Void Scale PP((double x, double y, double z));

extern Void Rotate PP((double angle, int axis));

/* Patch routines */
extern Void PatchBasis PP((float (*tbasis)[4], float (*ubasis)[4]));

extern Void PatchPrecision PP((long tseg, long useg));

extern Void PatchCurves PP((long nt, long nu));

extern Void Rpatch PP((float (*gx)[4], float (*gy)[4], float (*gz)[4],
		       float (*gw)[4]));

extern Void Patch PP((float (*gx)[4], float (*gy)[4], float (*gz)[4]));

/* Point routines */
extern Void Point PP((double x, double y, double z));

extern Void Point2 PP((double x, double y));

/* Object routines */
extern Void MakeObj PP((long n));

extern Void CloseObj PV();

extern long GenObj PV();

extern long GetOpenobj PV();

extern Void CallObj PP((long n));

extern long IsObj PP((long n));

extern long DelObj PP((long n));

extern Void LoadObj PP((long n, Char *filename));

extern Void SaveObj PP((long n, Char *filename));

/* Double Buffering */
extern long BackBuffer PV();

extern Void FrontBuffer PV();

extern Void SwapBuffers PV();

/* Position routines */
extern Void GetGp PP((double *x, double *y, double *z));

extern Void GetGpT PP((double *x, double *y, double *z, double *w));

extern Void GetGp2 PP((double *x, double *y));

extern Void SgetGp2 PP((double *x, double *y));


Static string_t device;
Static Poly3_array_t parray;
Static long i;


Static Void init()
{
  /*
   * Don't ya just love pascal....
   */
  parray[0][0] = -8.0;
  parray[0][1] = -8.0;
  parray[0][2] = 0.0;
  parray[1][0] = -5.0;
  parray[1][1] = -8.0;
  parray[1][2] = 0.0;
  parray[2][0] = -5.0;
  parray[2][1] = -5.0;
  parray[2][2] = 0.0;
  parray[3][0] = -8.0;
  parray[3][1] = -5.0;
  parray[3][2] = 0.0;
}


Static Void drawpoly()
{
  Color((long)YELLOW);

  /*
   * Draw a polygon using poly, parray is our array of
   * points and 4 is the number of points in it.
   */
  Poly(4L, parray);

  Color((long)GREEN);

  /*
   * Draw a 5 sided figure by using move, draw and closepoly.
   */
  MakePoly();
  Move(0.0, 0.0, 0.0);
  Draw(3.0, 0.0, 0.0);
  Draw(3.0, 4.0, 0.0);
  Draw(-1.0, 5.0, 0.0);
  Draw(-2.0, 2.0, 0.0);
  ClosePoly();

  Color((long)MAGENTA);

  /*
   * draw a sector representing a 1/4 circle
   */
  Sector(1.5, -7.0, 3.0, 0.0, 90.0);

  i = GetKey();
}


main(argc, argv)
int argc;
Char *argv[];
{
  PASCAL_MAIN(argc, argv);
  /*
   * Using polygons, hatching, and filling.
   */
  init();
  printf("Enter output device: ");
  gets(device);

  Voutput("ppoly.ps");
  Vinit(device);

  Color((long)BLACK);   /* clear to bleck */
  Clear();

  /*
   * world coordinates are now in the range -10 to 10
   * in x, y, and z. Note that positive z is towards us.
   */
  Ortho(-10.0, 10.0, -10.0, 10.0, 10.0, -10.0);

  Color((long)YELLOW);

  /*
   * write out the string "Polygon from poly()" in the
   * starting at (-8.0, -4.0) and scaled to be 4.0 units long,
   * 0.5 units high.
   */
  BoxText(-8.0, -4.0, 4.0, 0.5, "Polygon from poly()");

  Color((long)GREEN);

  /*
   * write out a scaled string starting at (0.0, 6.0)
   */
  BoxText(0.0, 6.0, 4.0, 0.5, "Polygon from move()/ draw()");

  Color((long)MAGENTA);

  /*
   * write out a scaled string starting at (0.0, 6.0)
   */
  BoxText(3.5, -3.5, 1.9, 0.5, "Sector");

  drawpoly();   /* draw some polygons */

  /*
   * turn on polygon hatching
   */
  PolyHatch(true);
  HatchAng(45.0);
  HatchPitch(0.3);

  /*
   *  Rotate 20 degrees around x and 30 around y
   */
  Rotate(20.0, 'x');
  Rotate(30.0, 'y');

  drawpoly();   /* draw some polygons with hatching */

  /*
   * turn on polygon filling - this automatically turns off hatching
   */
  PolyFill(true);

  /*
   *  Do another set of rotations.
   */
  Rotate(20.0, 'x');
  Rotate(30.0, 'y');

  drawpoly();   /* draw some polygons with filling */

  Vexit();
  exit(EXIT_SUCCESS);
}



/* End. */
