/* Output from p2c, the Pascal-to-C translator */
/* From input file "pmoretxt.p" */


#include <p2c/p2c.h>


/*
        Vogle Pascal header file for Sun Pascal

        link with:

        pc progname.p -lvogle -lsuntool -lsunwindow -lpixrect -lm

*/

/* Standard Colour Indices */

#define BLACK           0
#define RED             1
#define GREEN           2
#define YELLOW          3
#define BLUE            4
#define MAGENTA         5
#define CYAN            6
#define WHITE           7

/* Maximum number of vertices in a polygon */
#define MAXVERTS        128
/* Maximum length of a string type */
#define MAXSTRINGLEN    255
/* Maximum number of "curve" geometries (for curven) */
#define MAXCURVEN       200


/* The type of stings passed to various VOGLE routines... */
typedef Char string_t[MAXSTRINGLEN + 1];


/* For getmatrix and loadmatrix etc, etc... */
typedef float Matrix44_t[4][4];
typedef float Matrix43_t[4][3];

/* For Poly and Poly2 .... */
typedef float Coord2[2];
typedef float Coord3[3];
typedef float Coord4[4];
typedef Coord2 Poly2_array_t[MAXVERTS];
typedef Coord3 Poly3_array_t[MAXVERTS];

/* For Curven....*/
typedef float GeomMat_t[MAXCURVEN][3];

/* Device routines */


extern Void Vinit PP((Char *device));

extern Void Vexit PV();

extern Void Voutput PP((Char *path));

extern Void VnewDev PP((Char *device));

extern Void VgetDev PP((Char *device));

extern long GetDepth PV();

extern Void VsetFlush PP((int yesno));

extern Void Vflush PV();

/* Routines for Setting Up Windows */
extern Void PrefPosition PP((long x, long y));

extern Void PrefSize PP((long width, long height));

/* General routines */
extern Void Clear PV();

extern Void Color PP((long col));

extern Void MapColor PP((long indx, long red, long green, long blue));

extern Void Clipping PP((int on));

extern long GetKey PV();

extern long CheckKey PV();

extern long GetString PP((long bcol, Char *string));

extern long Locator PP((double *xaddr, double *yaddr));

extern long Slocator PP((double *xaddr, double *yaddr));

/* Viewport routines */
extern Void ViewPort PP((double left, double right, double bottom, double top));

extern Void PushViewPort PV();

extern Void PopViewPort PV();

extern Void GetViewPort PP((double *left, double *right, double *bottom,
			    double *top));

/* Getting the aspect details */
extern double GetAspect PV();

extern Void GetFactors PP((double *w, double *h));

extern Void GetDisplaySize PP((double *w, double *h));

/* Attribute stack routines */
extern Void PushAttributes PV();

extern Void PopAttributes PV();

/* Projection routines */
extern Void Ortho PP((double left, double right, double bottom, double top,
		      double near_, double far_));

extern Void Ortho2 PP((double left, double right, double bottom, double top));

extern Void Perspective PP((double fov, double aspect, double near_,
			    double far_));

extern Void Window PP((double left, double right, double bottom, double top,
		       double near_, double far_));

/* Matrix stack routines */
extern Void PushMatrix PV();

extern Void PopMatrix PV();

/* Viewpoint routines */
extern Void PolarView PP((double distance, double azimuth, double incidence,
			  double twist));

extern Void Up PP((double x, double y, double z));

extern Void LookAt PP((double vx, double vy, double vz, double px, double py,
		       double pz, double twist));

/* Moving routines */
extern Void Move PP((double x, double y, double z));

extern Void Rmove PP((double dx, double dy, double dz));

extern Void Move2 PP((double x, double y));

extern Void Rmove2 PP((double dx, double dy));

extern Void Smove2 PP((double x, double y));

extern Void Rsmove2 PP((double dx, double dy));

/* Drawing routines */
extern Void SetDash PP((double d));

extern Void LineStyle PP((Char *str));

extern Void Draw PP((double x, double y, double z));

extern Void Rdraw PP((double dx, double dy, double dz));

extern Void Draw2 PP((double x, double y));

extern Void Rdraw2 PP((double dx, double dy));

extern Void Sdraw2 PP((double x, double y));

extern Void Rsdraw2 PP((double dx, double dy));

/* Arcs and circles */
extern Void CirclePrecision PP((long nsegs));

extern Void Arc PP((double x, double y, double radius, double start_angle,
		    double end_angle));

extern Void Sector PP((double x, double y, double radius, double start_angle,
		       double end_angle));

extern Void Circle PP((double x, double y, double radius));

/* Curve routines */
extern Void CurveBasis PP((float (*basis)[4]));

extern Void CurvePrecision PP((long nsegs));

extern Void Rcurve PP((float (*geom)[4]));

extern Void Curve PP((float (*geom)[3]));

extern Void Curven PP((long n, float (*geom)[3]));

/* Rectangles and general polygon routines */
extern Void Rect PP((double x1, double y1, double x2, double y2));

extern Void PolyFill PP((int on));

extern Void PolyHatch PP((int on));

extern Void HatchAng PP((double angle));

extern Void HatchPitch PP((double pitch));

extern Void Poly2 PP((long n, Coord2 *points));

extern Void Poly PP((long n, Coord3 *points));

extern Void MakePoly PV();

extern Void ClosePoly PV();

extern Void BackFace PP((int onoff));

extern Void BackFaceDir PP((int clockwise));

/* Text routines */
extern Void Font PP((Char *fontname));

extern long NumChars PV();

extern Void TextSize PP((double width, double height));

extern Void TextAng PP((double angle));

extern Void FixedWidth PP((int on));

extern Void CenterText PP((int on));

extern Void TextJustify PP((long val));

extern Void LeftJustify PV();

extern Void RightJustify PV();

extern Void TopJustify PV();

extern Void BottomJustify PV();

extern Void XcenterText PV();

extern Void YcenterText PV();

extern Void GetCharSize PP((int c, double *width, double *height));

extern Void GetFontSize PP((double *width, double *height));

extern Void DrawChar PP((int c));

extern Void DrawStr PP((Char *str));

extern Void StrLength PP((Char *str));

extern Void BoxText PP((double x, double y, double l, double h, Char *s));

extern Void BoxFit PP((double l, double h, long nchars));

/* Transformation routines */
extern Void Translate PP((double x, double y, double z));

extern Void Scale PP((double x, double y, double z));

extern Void Rotate PP((double angle, int axis));

/* Patch routines */
extern Void PatchBasis PP((float (*tbasis)[4], float (*ubasis)[4]));

extern Void PatchPrecision PP((long tseg, long useg));

extern Void PatchCurves PP((long nt, long nu));

extern Void Rpatch PP((float (*gx)[4], float (*gy)[4], float (*gz)[4],
		       float (*gw)[4]));

extern Void Patch PP((float (*gx)[4], float (*gy)[4], float (*gz)[4]));

/* Point routines */
extern Void Point PP((double x, double y, double z));

extern Void Point2 PP((double x, double y));

/* Object routines */
extern Void MakeObj PP((long n));

extern Void CloseObj PV();

extern long GenObj PV();

extern long GetOpenobj PV();

extern Void CallObj PP((long n));

extern long IsObj PP((long n));

extern long DelObj PP((long n));

extern Void LoadObj PP((long n, Char *filename));

extern Void SaveObj PP((long n, Char *filename));

/* Double Buffering */
extern long BackBuffer PV();

extern Void FrontBuffer PV();

extern Void SwapBuffers PV();

/* Position routines */
extern Void GetGp PP((double *x, double *y, double *z));

extern Void GetGpT PP((double *x, double *y, double *z, double *w));

extern Void GetGp2 PP((double *x, double *y));

extern Void SgetGp2 PP((double *x, double *y));


Static string_t dev;
Static long i;
Static double x;


/*
 * drawgrid
 *
 *draw a grid in the middle of the screen
 */
Static Void drawgrid()
{
  double x;
  long i;

  Color((long)GREEN);

  Rect(0.1, 0.4, 0.9, 0.6);

  x = 0.2;

  for (i = 0; i <= 7; i++) {
    Move2(x, 0.4);
    Draw2(x, 0.6);
    x += 0.1;
  }

  Move2(0.1, 0.5);
  Draw2(0.9, 0.5);

  Color((long)YELLOW);
}


/*
 * demonstrate some more features of text
 */

main(argc, argv)
int argc;
Char *argv[];
{
  PASCAL_MAIN(argc, argv);
  printf("Enter device: ");
  gets(dev);

  Vinit(dev);
  Color((long)BLACK);
  Clear();

  Ortho2(0.0, 1.0, 0.0, 1.0);

  drawgrid();

  /*
   * show some scaled text on the grid (In the bottom part)
   */
  BoxText(0.1, 0.4, 0.8, 0.1, "{This is Some text] | $");

  i = GetKey();

  Color((long)BLACK);
  Clear();

  drawgrid();

  /*
   * centertext causes text to be centered around the current graphics
   * position this is especially usefull if you want your text to come
   * out centered on a line, or a character to be centered on a point
   * in a graph. A non-zero argument turns centertext on.
   *
   * show a string centered on the center line
   */
  CenterText(true);

  BoxText(0.5, 0.5, 0.8, 0.1, "{This is Some Centered text] | $");

  /*
   * turn centertext off. We use an argument with the value zero.
   */
  CenterText(false);

  i = GetKey();

  Color((long)BLACK);
  Clear();

  /*
   * rotate the grid so that it is the same angle as the text after
   * textang for text ang.
   */
  PushMatrix();
  Translate(0.5, 0.5, 0.0);
  Rotate(90.0, 'z');
  Translate(-0.5, -0.5, 0.0);

  drawgrid();
  PopMatrix();

  /*
   * turn on centered text again
   */
  CenterText(true);

  /*
   * set the angle to 90.
   */
  TextAng(90.0);

  /*
   * draw the string
   */
  BoxText(0.5, 0.5, 0.8, 0.1, "{This is Some Rotated Centered text] | $");

  /*
   * turn off center text
   */
  CenterText(false);

  /*
   * set text angle back to 90
   */
  TextAng(0.0);

  i = GetKey();

  Color((long)BLACK);
  Clear();

  drawgrid();

  /*
   * as all the software fonts are proportionally spaced we use
   * the fixedwidth call to make each character take the same amount
   * of horizontal space. As with centertext this is done by passing
   * fixedwidth a non-zero argument.
   */
  FixedWidth(true);

  BoxText(0.1, 0.5, 0.8, 0.1, "{This is Some Fixedwidth text] | $");

  i = GetKey();

  Color((long)BLACK);
  Clear();

  drawgrid();

  /*
   * now try centered and fixewidth at the same time
   */
  CenterText(true);

  Move2(0.5, 0.5);
  DrawStr("{This is Some Cent.Fixedwidth text] | $");

  CenterText(false);

  i = GetKey();
  Color((long)BLACK);
  Clear();

  drawgrid();

  /*
   * scale the text so tha a character is the size of a box in
   * the grid.
   */
  BoxFit(0.8, 0.1, 8L);

  /*
   * draw the two strings fixedwidth (it is still turned on)
   */
  Move2(0.1, 0.4);
  DrawStr("ABCDefgh");

  Move2(0.1, 0.5);
  DrawStr("IJKLmnop");

  i = GetKey();

  Vexit();
  exit(EXIT_SUCCESS);
}



/* End. */
