
/* A minimal Wavefront to off converter */
/* based on Jeff Katcher's obj2ray.c    */

#include <stdio.h>
#include <string.h>

#define LINELEN 255
#define NEWLINE '\n'

#define MAX_VERTEX_PER_FACE 20

#define VF_NONE   0;
#define VF_SMOOTH 1;

typedef struct {
   float r,g,b;
} color;


color colortable[] =
{
  {0.0, 0.0, 0.5},
  {0.0, 0.0, 1.0},
  {0.0, 0.5, 0.0},
  {0.0, 0.5, 0.5},
  {0.0, 0.5, 1.0},
  {0.0, 1.0, 0.0},
  {0.0, 1.0, 0.5},
  {0.0, 1.0, 1.0},
  {0.5, 0.0, 0.0},
  {0.5, 0.0, 0.5},
  {0.5, 0.0, 1.0},
  {0.5, 0.5, 0.0},
  {0.5, 0.5, 0.5},
  {0.5, 0.5, 1.0},
  {0.5, 1.0, 0.0},
  {0.5, 1.0, 0.5},
  {0.5, 1.0, 1.0},
  {1.0, 0.0, 0.0},
  {1.0, 0.0, 0.5},
  {1.0, 0.0, 1.0},
  {1.0, 0.5, 0.0},
  {1.0, 0.5, 0.5},
  {1.0, 0.5, 1.0},
  {1.0, 1.0, 0.0},
  {1.0, 1.0, 0.5},
  {1.0, 1.0, 1.0}
};

#define N_COLOR 26

typedef struct {
   float  x, y, z;
 } vertex;

vertex *vertices  = NULL;
int v_count       = 0;

typedef struct
{
  int nvertex;
  int vertex[MAX_VERTEX_PER_FACE];
  int group;
} face;

face *faces   = NULL;
int   f_count = 0;
int   current_group = 0;
int   max_group     = 0;


char *ipcolname(s)
char *s;
{
  static char tmp[300];
  char *p;
  strcpy(tmp,s);
  p = strchr(s,'.');
  if(!p)
    p = tmp + strlen(tmp);

  strcpy(p,".ipcol");

  return tmp;
}

void strip_newline(line)
char *line;
{
   char *s;

   if (s=strrchr(line,NEWLINE))
      *s=0;
}

int add_vertex(line)
char *line;
{
   if (!v_count)
      vertices=(vertex *)malloc(sizeof(vertex));
   else
      vertices=(vertex *)realloc(vertices,sizeof(vertex)*(v_count+1));

   sscanf(line,"v %f %f %f",&(vertices[v_count].x),
      &(vertices[v_count].y),&(vertices[v_count].z));

   return(++v_count);
}

void add_vertex_normal(line)
char *line;
{
  float x,y,z;

  sscanf(line,"vn %f %f %f",&x, &y, &z);
}


face *add_face()
{
  if(!f_count)
    faces = (face *)malloc(sizeof(face));
  else
    faces = (face *)realloc(faces, sizeof(face)*(f_count+1));
  faces[f_count].nvertex = 0;
  faces[f_count].group   = current_group;
  f_count++;
  return &(faces[f_count - 1]);
}


void add_vertex_face(F, v)
face *F;
int   v;
{
  F->vertex[F->nvertex++] = v;
}


int count_sides(line)
char *line;
{
   char *s;
   int count=0;

   s=strdup(line);
 
   strtok(s," "); /* skip 'f' type identifier */
   while (strtok(NULL," "))
      count++;

   free(s);

   return(count);
}

void parse_facet(line)
char *line;
{
   char *token;
   char *split;
   int vertice;
   int normal;
   int sides;
   face *F = add_face();

   sides=count_sides(line);

   strtok(line," "); /* skip 'f' type identifier */
   while (token=strtok(NULL," "))
      {
      vertice=atoi(token);
      add_vertex_face(F,vertice);

      if (sides==3 && (split=strstr(token,"//")))
         {
         normal=atoi(split+2)-1;
         }
      }
}

void convert_comment(line)
char *line;
{
   char *s;
   printf("/* %s */\n",(s=strchr(line,' '))?s+1:line+1);  
}

main(argc,argv)
int argc;
char **argv;
{
   FILE *fp, *ipcol;
   char line[LINELEN+1];
   char *s;

   int i,j,a_count;

   if (argc!=2)
      fprintf(stderr,"obj2off: obj2off <input.obj>\n");
   else
      if (!(fp=fopen(argv[1],"r")))
         fprintf(stderr,"obj2off: could not open '%s' for input\n",argv[1]);
      else
         {
         while (fgets(line,LINELEN,fp))
            {
            strip_newline(line);

            switch (*line)
               {
               case '#': /* comment */
               case '$': /* seems to be comment */
/*                  convert_comment(line); */
                  break;

               case 'v': /* vertex */
                  switch (*(line+1))
                     {
                     case ' ': /* regular vertex 'v' */
                        add_vertex(line);
                        break;

                     case 'n': /* vertex normal 'vn' */
                        add_vertex_normal(line);
                        break;

                     default: /* unsupported vertex type */
                        fprintf(stderr,"Unsupported vertex type: '%s'\n",line);
                     }
                  break;

               case 'g': /* group */
		    current_group = atoi(line+1);
		    max_group = (current_group > max_group) ? 
                                 current_group : 
                                 max_group;
                  break;

               case 's': /* smoothing group # */
		    current_group = atoi(line+1);
		    max_group = (current_group > max_group) ? 
                                 current_group : 
                                 max_group;
                  break;

               case 'f': /* facet */
                  parse_facet(line);
                  break;

               case NULL: /* Empty line */
                  printf("\n");
                  break;

               default:
                  fprintf(stderr,"Error: cannot handle: '%s'\n",line);
               }
            }

         fclose(fp);

	 fprintf(stderr,"obj2off: %d vertices - %d faces\n", v_count, f_count);


	 for(i=0,a_count=0; i<f_count; i++)
	   a_count += faces[i].nvertex;
	 
	 printf("%d %d %d\n",v_count, f_count, a_count);

	 for(i=0; i<v_count; i++)
	   printf("%f %f %f\n",vertices[i].x, vertices[i].y, vertices[i].z);

	 for(i=0; i<f_count; i++)
	   {
	     printf("%d ",faces[i].nvertex);
	     for(j=0; j<faces[i].nvertex; j++)
	       printf("%d ",faces[i].vertex[faces[i].nvertex - j - 1]);
	     printf("\n");
	   }

       if(!(ipcol = fopen("/tmp/dummy.ipcol","w"))) 
	 fprintf(stderr,"could not create ipcol file\n");
       else
	 {
	   if(!max_group)
	     fprintf(stderr,"no group information\n");
	   else
	     {
	       max_group++;
	       fprintf(ipcol,"%d %d\n",max_group, f_count);
	       for(i=0; i<max_group; i++)
		 fprintf(ipcol,"%f %f %f\n",
			 colortable[i % N_COLOR].r,
			 colortable[i % N_COLOR].g,
			 colortable[i % N_COLOR].b);

	       for(i=0; i<f_count; i++)
		 fprintf(ipcol,"%d\n",faces[i].group + 1);

	       fclose(ipcol);
	     }
	 }

       }
 }
