/*
 * Convert a nff mesh
 * to a geom mesh.
 */

#include <stdio.h>
#include <stdlib.h>


int main(int argc, char **argv)
{
  FILE* f;
  int nvertex = 0;
  int nface   = 0;
  int nside   = 0;
  int nvertexinface;
  int i,j;
  float x,y,z;
  int vertex;
  char line[300];


  if(argc != 2)
    {
      fprintf(stderr,"Wrong # of arguments\n");
      fprintf(stderr,"Usage: off2off filename.ts\n");
      exit(-1);
    }

  if(!(f = fopen(argv[1], "rt")))
    {
      fprintf(stderr,"could not open file\n");
      exit(-1);
    }

   
  fgets(line, 300, f);
  fgets(line, 300, f);
  
  fscanf(f,"%d",&nvertex);

  for(i=0; i<nvertex; i++)
      fscanf(f,"%f%f%f",&x,&y,&z);

  fscanf(f,"%d",&nface);

  fprintf(stderr, "input : %d vertice - %d faces\n",nvertex, nface);

  printf("%d  %d  %d\n",nvertex, nface, 0);

  fseek(f,0, SEEK_SET);

  fgets(line, 300, f);
  fgets(line, 300, f); 
   
  fscanf(f,"%d",&nvertex);


  for(i=0; i<nvertex; i++)
      {
	  fscanf(f,"%f%f%f",&x,&y,&z);
	  printf("%f %f %f\n",x,y,z);
      }

  fscanf(f,"%d",&nface); 
   
  for(i=0; i<nface; i++)
      {
	fscanf(f,"%d",&nvertexinface);
	printf("%d  ",nvertexinface); 
	for(j=0; j<nvertexinface; j++)
	  {
	    fscanf(f,"%d",&vertex);
	    printf("%d ",vertex+1);
	  }
      
	printf("\n");
	fgets(line, 300, f);

      }


  fclose(f);
  return 0;
}



