
/*
 *
 * generate dummy ipcol files
 *
 */


#include <stdlib.h>
#include <stdio.h>

typedef struct {
   float r,g,b;
} color;


color colortable[] =
{
  {0.0, 0.0, 1.0},
  {0.0, 1.0, 0.0},
  {0.0, 1.0, 1.0},
  {1.0, 0.0, 0.0},
  {1.0, 0.0, 1.0},
  {1.0, 1.0, 0.0},
  {1.0, 1.0, 1.0}
};

#define N_COLOR 7

int main(int argc, char **argv)
{
  int n,i;

  if(argc != 2)
    {
      fprintf(stderr, "usage:ipcolgen n\n");
      exit(-1);
    }

  if(!(n = atoi(argv[1])))
    {
      fprintf(stderr, "usage:ipcolgen n\n");
      exit(-1);
    }

  printf("%d  %d\n", N_COLOR, n);
  
  for(i=0; i<N_COLOR; i++)
    printf("%f %f %f\n", colortable[i].r, colortable[i].g, colortable[i].b);

  for(i=0; i<n; i++)
    printf("%d\n",(i%N_COLOR) + 1);
    
  return 1;
}
