/*
 * Invert normals
 */

#include <stdio.h>
#include <stdlib.h>


int main(int argc, char **argv)
{
  FILE* f;
  int nvertex = 0;
  int nface   = 0;
  int nside   = 0;
  int nfaceout   = 0;
  int nvertexout = 0;
  int i,j;
  float x,y,z;
  int nvertexinface;
  int facevertex[1024];
  int vertex;

  if(argc != 2)
    {
      fprintf(stderr,"Wrong # of arguments\n");
      fprintf(stderr,"Usage: invgeom filename.geom\n");
      exit(-1);
    }

  if(!(f = fopen(argv[1], "rt")))
    {
      fprintf(stderr,"could not open file\n");
      exit(-1);
    }

  
  fscanf(f,"%d%d%d",&nvertex, &nface, &nside);

  printf("%d   %d   %d\n", nvertex, nface, nside);


  for(i=0; i<nvertex; i++)
    {
      fscanf(f,"%f%f%f",&x,&y,&z);
      printf("%f %f %f\n",x,y,z);
    }

  for(i=0; i<nface; i++)
      {
	  fscanf(f,"%d",&nvertexinface);
	  for(j=0; j<nvertexinface; j++)
	      fscanf(f,"%d",&(facevertex[j]));

	  printf("%d     ",nvertexinface);

	  for(j=0; j<nvertexinface; j++)
	    printf("%d ",facevertex[nvertexinface-j-1]);
	  
	  printf("\n");
      }

  fprintf(stderr, "input : %d vertice - %d faces\n",nvertex, nface);

  fclose(f);
  return 0;
}



