/*
 * Convert an off mesh to 
 * a triangular off mesh.
 */

#include <stdio.h>
#include <stdlib.h>


typedef struct
{
  float x,y,z;
} Vertex;

int main(int argc, char **argv)
{
  FILE* f;
  int nvertex = 0;
  int nface   = 0;
  int nside   = 0;
  int nfaceout   = 0;
  int nvertexout = 0;
  int i,j;
  float x,y,z;
  int nvertexinface;
  int facevertex[255];
  int vertex;
  Vertex *vertices;


  if(argc != 2)
    {
      fprintf(stderr,"Wrong # of arguments\n");
      fprintf(stderr,"Usage: off2off filename.ts\n");
      exit(-1);
    }

  if(!(f = fopen(argv[1], "rt")))
    {
      fprintf(stderr,"could not open file\n");
      exit(-1);
    }

  
  fscanf(f,"%d%d%d",&nvertex, &nface, &nside);

  nvertexout = nvertex + nface;

  vertices = (Vertex *)malloc(sizeof(Vertex) * nvertexout);

  for(i=0; i<nvertex; i++)
    {
      fscanf(f,"%f%f%f",&x,&y,&z);
      vertices[i].x = x;
      vertices[i].y = y;
      vertices[i].z = z;
    }

  for(i=0; i<nface; i++)
      {
	Vertex center;
	center.x = 0;
	center.y = 0;
	center.z = 0;
	fscanf(f,"%d",&nvertexinface);
	for(j=0; j<nvertexinface; j++)
	  {
	    fscanf(f,"%d",&vertex);
	    center.x += vertices[vertex-1].x;
	    center.y += vertices[vertex-1].y;
	    center.z += vertices[vertex-1].z;
	  }
	center.x /= nvertexinface;
	center.y /= nvertexinface;
	center.z /= nvertexinface;
	vertices[i+nvertex] = center;
	nfaceout += nvertexinface;
      }



  fprintf(stderr, "input : %d vertice - %d faces\n",nvertex, nface);
  fprintf(stderr, "output: %d vertice - %d faces\n",nvertexout, nfaceout);

  printf("%d  %d  %d\n",nvertexout, nfaceout, nfaceout * 3);

  fseek(f,0, SEEK_SET);

  fscanf(f,"%d%d%d",&nvertex, &nface, &nside);


  for(i=0; i<nvertex; i++)
    fscanf(f,"%f%f%f",&x,&y,&z);

  for(i=0; i<nvertexout; i++)
    printf("%f %f %f\n",vertices[i].x, vertices[i].y, vertices[i].z);

  for(i=0; i<nface; i++)
      {
	fscanf(f,"%d",&nvertexinface);
	for(j=0; j<nvertexinface; j++)
	  fscanf(f,"%d",&(facevertex[j]));

	for(j=0; j<nvertexinface; j++)
	  printf("3   %d  %d  %d\n",
		 facevertex[j], facevertex[(j+1) % nvertexinface], nvertex + i + 1);
      }


  fclose(f);
  return 0;
}



