/*
 * Convert an off mesh to 
 * a triangular off mesh.
 */

#include <stdio.h>
#include <stdlib.h>


int main(int argc, char **argv)
{
  FILE* f;
  int nvertex = 0;
  int nface   = 0;
  int nside   = 0;
  int nfaceout   = 0;
  int nvertexout = 0;
  int i,j;
  float x,y,z;
  int nvertexinface;
  int facevertex[255];
  int vertex;

  if(argc != 2)
    {
      fprintf(stderr,"Wrong # of arguments\n");
      fprintf(stderr,"Usage: off2off filename.ts\n");
      exit(-1);
    }

  if(!(f = fopen(argv[1], "rt")))
    {
      fprintf(stderr,"could not open file\n");
      exit(-1);
    }

  
  fscanf(f,"%d%d%d",&nvertex, &nface, &nside);


  for(i=0; i<nvertex; i++)
      fscanf(f,"%f%f%f",&x,&y,&z);

  for(i=0; i<nface; i++)
      {
	  fscanf(f,"%d",&nvertexinface);
	  for(j=0; j<nvertexinface; j++)
	      fscanf(f,"%d",&vertex);

	  nfaceout += nvertexinface - 2;
      }

  fprintf(stderr, "input : %d vertice - %d faces\n",nvertex, nface);
  fprintf(stderr, "output: %d vertice - %d faces\n",nvertex, nfaceout);

  printf("%d  %d  %d\n",nvertex, nfaceout, nfaceout * 3);

  fseek(f,0, SEEK_SET);

  fscanf(f,"%d%d%d",&nvertex, &nface, &nside);


  for(i=0; i<nvertex; i++)
      {
	  fscanf(f,"%f%f%f",&x,&y,&z);
	  printf("%f %f %f\n",x,y,z);
      }

  for(i=0; i<nface; i++)
      {
	  fscanf(f,"%d",&nvertexinface);
	  for(j=0; j<nvertexinface; j++)
	      fscanf(f,"%d",&(facevertex[j]));

	  for(j=0; j + 2 < nvertexinface; j++)
	      printf("3   %d  %d  %d\n",
		     facevertex[0], facevertex[j+1], facevertex[j+2]);
      }


  fclose(f);
  return 0;
}



