/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * Author:      Bruno Levy
 *
 * Copyright (c) 1996, Bruno Levy.
 *
 */
/*
 *
 * DOSgport.h
 * A GraphicPort for MicroSh*t - DOS, works with djgpp only.
 *
 */


#ifndef DOSGPORT_H
#define DOSGPORT_H

#include "gport.h"
#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include <pc.h>

const int DGPE_OK     = 0;
const int DGPE_MODE   = 1;
const int DGPE_MALLOC = 2;


const int DGPR_IMGBUFFER = 1;
const int DGPR_ZBUFFER   = 2;

const int VESA_256 = 1;
const int VESA_32K = 2;
const int VESA_64K = 3;
const int VESA_16M = 4;

typedef struct
{
   int type;
   int width, height;
   int mode;
} VESA_mode;

class DOSGraphicPort : public GraphicPort
{
 public:

  DOSGraphicPort(char *name, ScrCoord width, ScrCoord height, 
	int verbose_level = 0);
  virtual ~DOSGraphicPort(void);
  virtual void CommitAttributes(void);


  virtual void RGBMode(void);
  virtual void ColormapMode(void);

  virtual int SingleBuffer(void);
  virtual int DoubleBuffer(void);
  virtual int SwapBuffers(void);
  virtual int ZBuffer(const int yes);

  virtual void MapColor(const ColorIndex i, 
			const ColorComponent r, 
			const ColorComponent g, 
			const ColorComponent b );  

  virtual int SetGeometry(const ScrCoord width, const ScrCoord height);

  virtual char GetKey(void);
  virtual int  GetMouse(ScrCoord *x, ScrCoord *y);
  virtual int  WaitEvent(void);

 protected: 

  Flags _resources;

  int  _size;
  int  _mode;
  int  _pages;
  int  _pad;
  int  _linear;


  ColorIndex *_r_graph_mem;
  ColorIndex *_v_graph_mem;

  static VESA_mode _vesa_table[];
  VESA_mode *_vesa_mode;

  int VESA_SetMode(int mode);
  int VESA_StdMode(int mode);
  int VESA_BankSwitch(int mode);
  int VESA_SetRGB(int idx, int r, int g, int b);

  void VESA_InitMouse();
  int  VESA_GetMouse(int *dx = NULL, int *dy = NULL);  
  void VESA_GetDeltaMouse(int *dx, int *dy);

  int  SetupScreen();

  int  AllocateZBuffer(void);
  void FreeZBuffer(void);

  int  AllocateImgBuffer(void);
  void FreeImgBuffer(void);

  void ResetColortable(void);
  void RestoreColortable(void);

  int  Resize(const ScrCoord width, const ScrCoord height);

  static GraphicPort *Make(char *name, ScrCoord width, ScrCoord height, 
			   int verb = MSG_NONE);

  friend class Stub;
};


#endif
