/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * Author:      Bruno Levy
 *
 * Copyright (c) 1996, Bruno Levy.
 *
 */
/*
 *
 * SVGAgport.h
 * A GraphicPort for SVGAlib under Linux
 *
 */


#ifndef SVGAGPORT_H
#define SVGAGPORT_H

#include "gport.h"
#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include <vga.h>

const int SGPE_OK     = 0;
const int SGPE_MODE   = 1;
const int SGPE_MALLOC = 2;


const int SGPR_IMGBUFFER = 1;
const int SGPR_ZBUFFER   = 2;
const int SGPR_HARDSWP   = 3;

class SVGAGraphicPort : public GraphicPort
{
 public:

  SVGAGraphicPort(char *name, ScrCoord width, ScrCoord height, int verbose_level = 0);
  virtual ~SVGAGraphicPort(void);
  virtual void CommitAttributes(void);


  virtual void RGBMode(void);
  virtual void ColormapMode(void);

  virtual int SingleBuffer(void);
  virtual int DoubleBuffer(void);
  virtual int SwapBuffers(void);
  virtual int ZBuffer(const int yes);

  virtual void MapColor(const ColorIndex i, 
			const ColorComponent r, 
			const ColorComponent g, 
			const ColorComponent b );  

  virtual int SetGeometry(const ScrCoord width, const ScrCoord height);

  virtual char GetKey(void);
  virtual int  GetMouse(ScrCoord *x, ScrCoord *y);
  virtual int  WaitEvent(void);

 public:
  static OpCode WAITVBL;
  static OpCode HARDSWP;
  virtual long Cntl(OpCode op, int arg);

 protected: 

  Flags _resources;

  int  _size;
  int  _mode;
  int  _pages;
  int  _pad;
  int  _linear;

  vga_modeinfo *_modeinfo;

  ColorIndex *_r_graph_mem;
  ColorIndex *_v_graph_mem;

  int  SetupScreen();

  int  AllocateZBuffer(void);
  void FreeZBuffer(void);

  int  AllocateImgBuffer(void);
  void FreeImgBuffer(void);

  void ResetColortable(void);
  void RestoreColortable(void);

  int  Resize(const ScrCoord width, const ScrCoord height);

  static GraphicPort *Make(char *name, ScrCoord width, ScrCoord height, 
			   int verb = MSG_NONE);

  friend class Stub;
};


#endif

