/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * Author:      Bruno Levy
 *
 * Copyright (c) 1996, Bruno Levy.
 *
 */
/*
 *
 * glinker.cc
 *
 */

#include "glinker.h"

GLinker::~GLinker(void)
{
  if(_resources.Get(GLR_DRIVERS))
    free(_drivers);
  if(_resources.Get(GLR_LIBPATH))
    free(_library);
}

GLinker::GLinker(int verbose_level) 
{
  Verbose(verbose_level);
  _proc_name = "GLinker";

  if(!(_library = getenv("GLIBRARY")))
    {
      (*this)[MSG_WARNING] << "GLIBRARY not set\n";
      (*this)[MSG_WARNING] << "using default " << DEFAULT_GLIB << "\n";
      _library = strdup(DEFAULT_GLIB);
    }
  else
    {
      _library = strdup(_library);
      (*this)[MSG_INFO] << "library path: " << _library << "\n";
    }

  _resources.Set(GLR_LIBPATH);

  if(_drivers = getenv("GDRIVERS"))
    {
      _resources.Set(GLR_DRIVERS);
      _drivers = strdup(_drivers);
      (*this)[MSG_INFO] << "using drivers: " << _drivers << "\n";
    }
  else
    {
      (*this)[MSG_WARNING] << "GDRIVERS not set\n";
      (*this)[MSG_WARNING] << "Nothing will be linked !!!\n";
      return;
    }
}

