/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * Author:      Bruno Levy
 *
 * Copyright (c) 1996, Bruno Levy.
 *
 */
/* 
 *
 * vtga.C - view a targa file with TAGL
 *
 */


#include "gport.h"
#include "polyeng.h"

#ifdef X_GPORT
#include "processors/gport/Xgport.h"
#endif

#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

GraphicPort   *GP;
PolygonEngine *PE;
int _direct = 0;

char TGA_Signature[] = { 0x00, 0x00, 0x02, 0x00, 0x00, 
                         0x00, 0x00, 0x00, 0x00, 0x00 };
                         

typedef struct
{
unsigned char Signature[10];
unsigned char FirstLine_L;
unsigned char FirstLine_H;
unsigned char Width_L;
unsigned char Width_H;
unsigned char Height_L;
unsigned char Height_H;
unsigned char bpp;
unsigned char mode;
} TGA_Header;

typedef struct
{
unsigned char B;
unsigned char G;
unsigned char R;
} TGA_Pixel;

int main(int argc, char **argv)
{

int fd;
TGA_Header H;
int x,y;
int FirstLine, Width, Height;
TGA_Pixel *Line;
int nrd;

if(argc != 2)
   {
      cerr << "usage: vtga filename.tga" << endl;
      exit(-1);
   }

if(!(fd = open(argv[1], O_RDONLY)))
   {
      perror("cannot open file");
      exit(-1);
   }

if(read(fd, (char *)&H, sizeof(TGA_Header)) < sizeof(TGA_Header))
   {
      perror("error while reading header");
      exit(-1);
   }

if(memcmp(TGA_Signature, H.Signature, (unsigned int)sizeof(TGA_Signature)))
   {
      cerr << "invalid TGA signature" << endl;
      exit(-1);
   }

if(H.mode != 32)
   {
      cerr << "Sorry, vtga cannot handle this kind of TGA file" << endl;
      exit(-1);
   }

if(H.bpp != 24)
   {
      cerr << "Sorry, vtga can handle 24bpp TGA files only" << endl;
      exit(-1);
   }

Width     = (int)H.Width_L     + (((int)H.Width_H)     << 8);
Height    = (int)H.Height_L    + (((int)H.Height_H)    << 8);
FirstLine = (int)H.FirstLine_L + (((int)H.FirstLine_H) << 8);

cerr << "Image:  "  << Width << "x" << Height << " " 
     << (int)(H.bpp) << "bpp" << endl;

if(!(GP = GraphicPort::Make(argv[1], Width, Height, MSG_NONE)))
   {
      cerr << "cannot open graphic port" << endl;
      exit(-1);
   }

if(!(PE = PolygonEngine::Make(GP, MSG_NONE)))
   {
      cerr << "cannot create polygon engine" << endl;
      exit(-1);
   }

#ifdef X_GPORT
GP->Cntl(XGraphicPort::RESIZE,0);
#endif

cerr << "Screen: " << GP->Width() << "x" << GP->Height() << " "
     << GP->BitsPerPixel() << "bpp" << endl;


_direct = GP->SingleBuffer();
GP->RGBMode();
PE->RGBMode();
PE->Dither(1);

if(!(Line = new TGA_Pixel[Width]))
   {
      perror("cannot allocate line buffer");
      exit(-1);
   }

for(y = 0; y < Height; y++)
   {
      if((nrd = read(fd, (char *)Line, Width * sizeof(TGA_Pixel))) < Width)
         {
            cerr << "file appears to be truncated" << endl;
            break;
	 }

      for(x=0; x < Width; x++)
         PE->SetPixel(x,y,Line[x].R, Line[x].G, Line[x].B);

      if(!_direct && !(y % 10))
         GP->SwapBuffers();

   }

close(fd);

delete[] Line;

if(!_direct)
   GP->SwapBuffers();

char q = 0;

while(q != 'q')
   {
     GP->WaitEvent();
     q = GP->GetKey();
     if(!_direct)
        GP->SwapBuffers();
   }

delete GP;

return 0;
}

