/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * Author:      Bruno Levy
 *
 * Copyright (c) 1996, Bruno Levy.
 *
 */
//
// simple.cc
//
// TAGL sample program
// Draw a green square
// (exciting, isn't it ?).
//

#include "gport.h"      // Header of the GraphicPort
#include "polyeng.h"    // Header of the PolygonEngine

const int width  = 320;
const int height = 200;

// A GVertex is a structure used by TAGL for 
// drawing polygons.

GVertex Poly[4];

int main(int argc, char **argv)
{

   // Building a GraphicPort (a window with a FrameBuffer) +
   // a PolygonEngine (a class that draws polygons).
   
   GraphicPort   *GP = GraphicPort::Make("Your first TAGL program", 
                                         width, height);
   PolygonEngine *PE = PolygonEngine::Make(GP);

   // Clear the GraphicPort.

   GP->Clear(BLACK);

   // Coordinates of the polygon.

   Poly[0].x = 30;
   Poly[0].y = 30;
   
   Poly[1].x = 30;
   Poly[1].y = height - 30;

   Poly[2].x = width  - 30;
   Poly[2].y = height - 30;
   
   Poly[3].x = width  - 30;
   Poly[3].y = 30;

   // Set current color to GREEN.
   // Do not forget D_SHIFT.

   PE->VAttributes().c = GREEN << D_SHIFT;

   // Draw the polygon.

   PE->Reset();
   PE->Push(&Poly[0]);
   PE->Push(&Poly[1]);
   PE->Push(&Poly[2]);
   PE->Push(&Poly[3]);
   PE->FillPoly();

   // Event loop.

   while(!GP->GetKey())
   {
      GP->SwapBuffers();
      GP->WaitEvent();
   }

   delete PE;
   delete GP;
   return 0;
}

