/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * Author:      Bruno Levy
 *
 * Copyright (c) 1996, Bruno Levy.
 *
 */
//
// rgbtri.cc
//
// TAGL sample program
// Draws a Gouraud shaded triangle
// in RGB mode.
//

#include "gport.h"
#include "polyeng.h"

const int width  = 640;
const int height = 480;


GVertex Poly[3];

int main(int argc, char **argv)
{
   GraphicPort   *GP = GraphicPort::Make(argv[0], width, height);
   PolygonEngine *PE = PolygonEngine::Make(GP);

   PE->Gouraud(1);
   GP->RGBMode();
   PE->RGBMode();
   PE->Dither(1);

   GP->Clear(0,0,0);

   Poly[0].x = width / 2;
   Poly[0].y = 10;
   Poly[0].r = 255;
   Poly[0].g = 0;
   Poly[0].b = 0;
   
   Poly[1].x = 10;
   Poly[1].y = height - 10;
   Poly[1].r = 0;
   Poly[1].g = 255;
   Poly[1].b = 0;

   Poly[2].x = width  - 10;
   Poly[2].y = height - 10;
   Poly[2].r = 0;
   Poly[2].g = 0;
   Poly[2].b = 255;

   PE->Reset();
   PE->Push(&Poly[0]);
   PE->Push(&Poly[1]);
   PE->Push(&Poly[2]);
   PE->FillPoly();

   while(!GP->GetKey())
      GP->SwapBuffers();
      
   delete GP;
   return 0;
}

