/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * Author:      Bruno Levy
 *
 * Copyright (c) 1996, Bruno Levy.
 *
 */
//
// mouse.cc
//
// TAGL sample program
// Demonstrate mouse input
// Left  button : draw
// Right button : change color
//

#include "gport.h"
#include "polyeng.h"

const int width  = 320;
const int height = 200;
const int size   = 5;

//
// Draw a square centered at x,y
//

void draw(PolygonEngine *PE, int x, int y, ColorCode c)
{
   PE->VAttributes().c = c << D_SHIFT;

   GVertex Poly[4];
   Poly[0].x = x - size;
   Poly[0].y = y - size;
   Poly[1].x = x - size;
   Poly[1].y = y + size;
   Poly[2].x = x + size;
   Poly[2].y = y + size;
   Poly[3].x = x + size;
   Poly[3].y = y - size;   

   PE->Reset();
   PE->Push(&Poly[0]);
   PE->Push(&Poly[1]);
   PE->Push(&Poly[2]);
   PE->Push(&Poly[3]);
   PE->FillPoly();
}

int main(int argc, char **argv)
{
   GraphicPort   *GP = GraphicPort::Make(argv[0], width, height);
   PolygonEngine *PE = PolygonEngine::Make(GP);
  
   int x = 0,y = 0,btn = 0,k = 0;
  
   GP->Clear((ColorIndex)0);

   int color = WHITE;


   while(!k)
   {  
      if(btn & (2 | 4))
	color = (color % 7) + 1;
      if(!(btn & 1))
         draw(PE, x, y, BLACK);
      k   = GP->GetKey();
      btn = GP->GetMouse(&x,&y);
      draw(PE, x, y, color);
      GP->SwapBuffers();
   }
   
   delete PE;
   delete GP;
   return 0;
}

