/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * Author:      Bruno Levy
 *
 * Copyright (c) 1996, Bruno Levy.
 *
 */
//
// halftone.cc
//
// TAGL sample program
// Demonstrate halftoning
// combined with Gouraud 
// shading.
//

#include "gport.h"
#include "polyeng.h"

const int width  = 640;
const int height = 480;
const int size   = 400;

//
// Wait for a key (and handle events)
//

void WK(GraphicPort *GP)
{
   while(!GP->GetKey())
      {
	 GP->SwapBuffers();
         GP->WaitEvent();
      }
}


//
// Draw a square. Left vertices have color c1,
// and right vertices have color c2.
//

void draw(PolygonEngine *PE, ColorCode c1, ColorCode c2)
{
   GVertex Poly[4];

   Poly[0].x = width  / 2 - size / 2;
   Poly[0].y = height / 2 - size / 2;
   Poly[0].c = c1 << D_SHIFT;  // Do not forget D_SHIFT !!!
   
   Poly[1].x = width  / 2 + size / 2;
   Poly[1].y = height / 2 - size / 2;
   Poly[1].c = c2 << D_SHIFT;

   Poly[2].x = width  / 2 + size / 2;
   Poly[2].y = height / 2 + size / 2;
   Poly[2].c = c2 << D_SHIFT;

   Poly[3].x = width  / 2 - size / 2;
   Poly[3].y = height / 2 + size / 2;
   Poly[3].c = c1 << D_SHIFT;

   PE->Reset();
   PE->Push(&Poly[0]);
   PE->Push(&Poly[1]);
   PE->Push(&Poly[2]);
   PE->Push(&Poly[3]);
   PE->FillPoly();
   PE->Port()->SwapBuffers();
}

//
// Install a color ramp between index idx1 and index idx2.
// A linear interpolation is performed between (r1,g1,b1)
// and (r2,g2,b2).

void ColorRamp(GraphicPort *GP, 
               ColorIndex idx1, 
               ColorComponent r1, ColorComponent g1, ColorComponent b1,
               ColorIndex idx2,
               ColorComponent r2, ColorComponent g2, ColorComponent b2)
	       
{
int i;
for(i=idx1; i<=idx2; i++)
  GP->MapColor(i,
               r1 + (i - (int)idx1)*(r2 - r1)/((int)idx2 - (int)idx1),
               g1 + (i - (int)idx1)*(g2 - g1)/((int)idx2 - (int)idx1),
               b1 + (i - (int)idx1)*(b2 - b1)/((int)idx2 - (int)idx1)
	      );
}

int main(int argc, char **argv)
{
   GraphicPort   *GP = GraphicPort::Make(argv[0], width, height);
   PolygonEngine *PE = PolygonEngine::Make(GP);

   GP->Clear((ColorIndex)BLACK);


   PE->Gouraud(1);
   draw(PE, GREEN, BLUE);
   WK(GP);

   PE->Dither(1);
   draw(PE, GREEN, BLUE);
   WK(GP);

   // A ColorRamp between colors 1 and 16 interpolating from
   // red to blue.
   
   ColorRamp(GP, 1, 255, 0, 0, 16, 0, 255, 255);
   PE->Dither(0);

   PE->Gouraud(1);
   draw(PE, 1, 16);
   WK(GP);

   PE->Dither(1);
   draw(PE, 1, 16);
   WK(GP);

   delete PE;
   delete GP;
   return 0;
}

