/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * Author:      Bruno Levy
 *
 * Copyright (c) 1996, Bruno Levy.
 *
 */
//
// fractidx.cc
//
// TAGL sample program
// Demonstrate fractional index
// colors.
//


#include "gport.h"
#include "polyeng.h"

const int width  = 640;
const int height = 480;

//
// Wait for a key (and handle events)
//

void WK(GraphicPort *GP)
{
   while(!GP->GetKey())
      {
	 GP->SwapBuffers();
         GP->WaitEvent();
      }
}

//
// Draw a triangle with color c
// (note that c is a float that may
//  have a fractional part)
//

void draw(PolygonEngine *PE, float color)
{
GVertex Poly[3];

   Poly[0].x = width / 2;
   Poly[0].y = 10;
   
   Poly[1].x = 10;
   Poly[1].y = height - 10;

   Poly[2].x = width  - 10;
   Poly[2].y = height - 10;
   
   PE->VAttributes().c = (ColorCode)(color * 16);

   PE->Reset();
   PE->Push(&Poly[0]);
   PE->Push(&Poly[1]);
   PE->Push(&Poly[2]);
   PE->FillPoly();
   
   PE->Port()->SwapBuffers();
}

int main(int argc, char **argv)
{
   float c;
   GraphicPort   *GP = GraphicPort::Make(argv[0], width, height);
   PolygonEngine *PE = PolygonEngine::Make(GP);

   GP->Clear((ColorIndex)BLACK);

   PE->Dither(1);

   for(c=0.2; c<=7; c+=0.2)
     {
       draw(PE, c);
       WK(GP);
     }
 
      
   delete GP;
   return 0;
}

