/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * Author:      Bruno Levy
 *
 * Copyright (c) 1996, Bruno Levy.
 *
 */
/*
 * 
 * cmdline.cc
 * 
 */

#include "cmdline.h"
#include <iostream.h>
#include <stdio.h>

void CmdLineUsage(char* cmdname, CmdLineArg* args)
{
   int arg = 0;
   
   cerr << "Usage: " << cmdname << " ";
   
   while(args[arg].type)
     {
	if(!args[arg].compulsory)
	   cerr << "[ ";
	
	cerr << args[arg].flag << " ";

	switch(args[arg].type)
	  {
	   case CMD_LINE_INT:
	     cerr << "<integer>";
	     break;
	   case CMD_LINE_FLT:
	     cerr << "<float>";
	     break;
	   case CMD_LINE_STR:
	     cerr << "<name>";
	     break;
	  }
	
	if(!args[arg].compulsory)
	   cerr << " ]";
	
	cerr << " ";
	
	arg++;
     }
   
   cerr << endl;
   CmdLineShowDefaults(cmdname, args);
}

void  CmdLineShowDefaults(char* cmdname, CmdLineArg* args)
{
   int arg = 0;
   
   cerr << "Current values: " << cmdname;
   
   while(args[arg].type)
     {
	if(args[arg].set)
	  {
	     cerr << args[arg].flag << " ";
	     switch(args[arg].type)
	       {
		case CMD_LINE_INT:
		  cerr << *(int *)args[arg].value; 
		  break;
		case CMD_LINE_FLT:
		  cerr << *(float *)args[arg].value;
		  break;
		case CMD_LINE_STR:
		  cerr << "\"" << *(char **)args[arg].value << "\""; 
		  break;
	       }
	  }
	
	cerr << " ";
	
	arg++;
     }
   
   cerr << endl;
}

static CmdLineArg* Find(CmdLineArg* args, char* flag)
{
   int arg;
   for(arg=0; args[arg].type; arg++)
      if(!strcmp(args[arg].flag, flag))
         return &args[arg];
   
   return NULL;
}

int CmdLineParse(int argc, char** argv, CmdLineArg* args)
{
   int arg = 1;
   
   while(arg < argc)
     {
	CmdLineArg* current; 
	if(!(current = Find(args, argv[arg])))
	  {
	     cerr << argv[0] << ": Does not understand " << argv[arg] << endl;
	     return 0;
	  }

	if(current->type == CMD_LINE_FLG)
	  *(int*)(current->value) = 1;
	
	else
	  {
	     arg++;
	     if(arg >= argc)
	       {
		  cerr << argv[0] << ": Missing value for " << argv[arg-1] << endl;
		  return 0;
	       }
	     
	     switch(current->type)
	       {
		  float val_f;
		  int   val_i;
		  
		case CMD_LINE_INT:
		  if(!sscanf(argv[arg],"%d",&val_i))
		    {
		       cerr << argv[0] << ": Invalid integer value: \':" << argv[arg] << "\'" << endl;
		       return 0;
		    }
		  *(int*)(current->value) = val_i;
		  break;
		case CMD_LINE_FLT:
		  if(!sscanf(argv[arg],"%f",&val_f))
		    {
		       cerr << argv[0] << ": Invalid float value: \':" << argv[arg] << "\'" << endl;		       
		       return 0;
		    }
		  *(float*)(current->value) = val_f;	     
		  break;
		case CMD_LINE_STR:
		  *(char**)(current->value) = argv[arg];
		  break;
	       }
	  }
	
	current->set = 1;
	arg++;
     }
   
   for(arg=0; args[arg].type; arg++)
      if(args[arg].compulsory && !args[arg].set)
         {
	    cerr << argv[0] << ": Missing value for " << args[arg].flag << endl;
	    return 0;
	 }
   
   return 1;
}
