###
###
#
# Global definitions for Makefiles.
# This file is included by all TAGL Makefiles.
# Modify it according to your system.
# or get the right makefile.inc in the config 
# directory.
#
###
###

#
# Configuration:
# g++
# HP-UX
# X11 XShm/ SVGAlib
#
#




# TAGL distribution tree

  TAGL_ROOT = $(HOME)/tagl22/
  TAGL_INC  = $(TAGL_ROOT)src/include/
  TAGL_LIB  = $(TAGL_ROOT)lib/lib/
  TAGL_DRV  = $(TAGL_ROOT)lib/drivers/
  TAGL_BIN  = $(TAGL_ROOT)bin/

  TAGL_ROOT2  = $(TAGL_ROOT)
  TAGL_INC2   = $(TAGL_INC)
  TAGL_LIB2   = $(TAGL_LIB)
  TAGL_DRV2   = $(TAGL_DRV)
  TAGL_BIN2   = $(TAGL_BIN)

# C and C++ compiler

  CXX=g++
  CC=gcc
  LDXX=g++
  LD=gcc

# Unix commands


  RM=rm -f
  CP=cp
  MV=mv

# makedepend doesn't know C++ include path
# let it blank if you don't know and ignore
# messages while 'make dep' if you use 'makedepend' (it does not matter ...).
# Default uses gcc -MM, so in most cases you don't have
# to bother about this ...

ALL_INCLUDES=

# dependancies file name
# I don't know why, but my dependancy file is not
# recognized under DOS.


DEP = $(TAGL_ROOT)/config/dummy.dep
# DEP=.dep

# optimize flags

OPTIMIZE= -O6 -DGINT -fomit-frame-pointer -funroll-loops -DNDEBUG
#OPTIMIZE= -O -DGINT -DNDEBUG
#OPTIMIZE= -g -DGINT

# X11 and SVGA special stuff.
# Add here include and linking path if needed.
# Remove -DX_SHM if your system does not have MIT X SHM.
# Remove -lvga if you don't have Linux SVGAlib.

  CCX11=-I/usr/include/X11R5 -DX_SHM 
  LDX11=-L/usr/lib/X11R5 -lX11 -lXext 

  CCSVGA=
  LDSVGA=

#
# Dynamic linking
#

#  CCDL=
#  LDDL=-ldld

# Add -DEBUG here for compiling
# assertion checks (slower).

CCOPT=$(OPTIMIZE) -DNDEBUG
CXXOPT=$(OPTIMIZE)

LDOPT=
LDXXOPT=-lm 

# Remove SVGAgport if you don't have Linux SVGAlib.
# Remove Xgport if you only have Linux SVGAlib.
# If you develop polygon engines, add them here.

# this is the default config - Link all drivers.
USEGPORTS   = Xgport 
USEPOLYENGS = peng_8 peng_32x Xpeng

# this is my config - I don't have a 24bpp X server for my mach32, sob !
#USEGPORTS   = Xgport SVGAgport
#USEPOLYENGS = peng_565 peng_8 Xpeng

# You should not need to modify these lines.
# See next comment ...

#SRCGPORTS   = $(USEGPORTS:%=%.cc)
#SRCPOLYENGS = $(USEPOLYENGS:%=%.cc)

#GPORTS      = $(USEGPORTS:%=%.o)
#POLYENGS    = $(USEPOLYENGS:%=%.o)

#LDGPORTS    = $(USEGPORTS:%=$(TAGL_DRV)%.o) $(LDX11) 
#LDPOLYENGS  = $(USEPOLYENGS:%=$(TAGL_DRV)%.o) $(LDX11) $(LDDL)
#LDPOLYENGS = $(LDDL)

           
# If your 'make' utility doesn't accept the previous decl,
# remove the previous declaration, uncomment the following
# ones, and remove the stuff you don't use from it.
# You can also change your 'make' command ( the one distributed with
# djgpp works well ... )
# I sincerely hope your 'make' supports it !!
#
SRCGPORTS=Xgport.cc 
SRCPOLYENGS=peng_8.cc peng_x32.cc Xpeng.cc
#
GPORTS=Xgport.o 
POLYENGS=peng_8.o peng_x32.o Xpeng.o
#
LDGPORTS=$(TAGL_DRV)/Xgport.o 
LDPOLYENGS=$(TAGL_DRV)/peng_8.o $(TAGL_DRV)/peng_x32.o $(TAGL_DRV)/Xpeng.o $(LDX11)

           
# some programs will use stuff specific to a graphic port (via the Cntl() call)
# remove the graphic ports you do not use from here.

CCGPORTS=$(CCX11) $(CCSVGA) -DX_GPORT 

#
# You should not need to modify this file 
# beyond this point.
#

LDGPORT=-L$(TAGL_LIB) -ltagl $(LDGPORTS) $(LDX11) $(LDSVGA)
LDPOLYENG=$(LDPOLYENGS)


CXXMOREOPT=$(CCX11) $(CCGPORTS) -DNDEBUG

.SUFFIXES: .o .c .cc

.cc.o:
	$(CXX) -c $(CXXOPT) $(CXXMOREOPT) -I$(TAGL_INC) $<

.c.o:
	$(CC) -c $(CCOPT) $(CCMOREOPT) $<

nothing:
	@echo make what ?

love:
	@echo Making love - do not disturb
	@echo OOOoooOOoooOOoooh
	@echo Rhahaaahaaahhhaaa

# If your compiler doesn't know the '-MM' option (generate dependancies),
# use 'makedepend' instead.
# If you don't have 'makedepend', replace it by a dummy file creation.
# I redirect stderr to /dev/null, because makedepend
# doesn't know C++ include path, and dependencies with
# my files are sufficient (I won't modify system includes ...)
# If you have defined ALL_INCLUDES properly, you can remove
# '&> /dev/null'.
#
#dep:
#	makedepend $(ALL_INCLUDES) -I$(TAGL_INC) $(SRC) &> /dev/null


dep: $(DEP)

#$(DEP): 
#	$(RM) $(DEP)
#	$(CC) -MM -I$(TAGL_INC) $(CCX11) $(CCSVGA) $(SRC) > $(DEP)

clean:
	$(RM) *.o *~ core* 

archie:
	tar cf $(PRJ).tar `ls *.c *.C *.h Makefile README*`

