/***************************************************
  Copyright (C) 1997:  Adrian Ratnapala

  This file is part of the library libppGui, see the file COPYING
  which should have come with that library.

  Contact the author:
    Adrian Ratnapala: a.ratnapala@mailbox.uq.edu.au

  ppUtils.cc:  Utility functions for parts of the linux gsdk.
               Although thiss file is C++ most of its external
               functions will probably be extern "C".
***/



#include <PenguinPlay.h>

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>



/***
*  ppBase: Base class for everything.  Should do nothing when debugging
*  is not on. 
***/

#ifdef PP_DEBUG

ppBase* ppBase::first_object=0;
int ppBase::next_id=0;


ppBase::ppBase()
{
  id=next_id++;

  prev = NULL;
  next = first_object;
  if(first_object)
    first_object->prev = this;
  first_object = this;

  ppDbgPrint("Creating object %d\n", id);
}

  
ppBase::~ppBase()
{
  if(prev)prev->next = next;
  if(next)next->prev = prev;
  ppDbgPrint("Destroying object %d\n", id);
}


//so the coding style here is a little strange. 
bool ppBase::dbIntegrityOk()const//check integrity of our bit of linked list.
{
#define CHOKE goto choke;
  if(prev){
    if(first_object==this) CHOKE;
    if(prev->next!=this) CHOKE;
  }else{
    if(first_object!=this) CHOKE;
  }
  if(next) if(next->prev!=this){ 
    ppWarning("NEXT %p: is not properly connected to me\n", next);
    next->dbDump(stderr);
    CHOKE;
  }

  return -1; //this is the successful exit.
#undef CHOKE

choke:
  ppWarning("Not properly connected to object list!\n");
  return 0;
}

  
char* ppBase::dbGetObjectName(char* buf, size_t len)const
{
  snprintf(buf, len, "%s_%06x", dbGetClassName(), id);
  return buf;
}

          
void ppBase::dbDump(FILE* out)const
{
  char* tmp=dbLeakyGetObjectName();
  fprintf(out, 
            "*********************\n"
            "Object Name: %s:\n", 
          tmp
         );
  if(! dbIntegrityOk()){
    fprintf(out, "Ohh, oh, the object is bad!\n");
  } 
};

void ppBase::dbDumpAll(FILE* out)
{
  if(!first_object){
    fprintf(out, "No Objects!\n");
  }
  for(ppBase* i=first_object; i; i=i->next)
    i->dbDump(out);
};


#else  //PP_DEBUG
#endif //!PP_DEBUG




/******************************
  Miscilaneus definitions
**/

//This becomes _PP_FUNCTION_NAME, when automatic function name getting is off.
#ifndef __GNUC__
const char* _ppNoFuncNameMsg = "Unknown Function";
#endif







/***********************
  User messages.

***/


/*FIX:  we need to make this much more flexible for the user.
  At the very least allow a file other than stderr, at the
  most, allow the user to implement this function in a nice
  way.
*/
#define outfile stderr


#ifdef PP_DEBUG

/*
  Some places to store data.  (Thread specific when we get around
  to that.
*/

/*line no of last debug message*/
int* _pp_db_lineno_loc(void){ static int n; return &n;}
/*function of last debug message*/
char** _pp_db_func_loc(void){ static char* n; return &n;}
/*filename of last debug message*/
char** _pp_db_file_loc(void){ static char* n; return &n;}

void do_dbg_msg(const char* type, 
       const char* msg, 
       va_list vargs){

  fprintf(outfile, "\n%s:\t In function %s at %s:%d\n",
    type,
    *_pp_db_func_loc(),
    *_pp_db_file_loc(),
    *_pp_db_lineno_loc()
  );
  vfprintf(outfile, msg, vargs);
}


void ppDbgPrint(const char* msg, ...){
va_list vargs;
  va_start(vargs, msg);
  vfprintf(outfile, msg, vargs);
  va_end(vargs); 
}

void _ppDbgDebug(const char* msg, ...){
va_list vargs;
  va_start(vargs, msg);
  do_dbg_msg("DEBUG", msg, vargs);
  va_end(vargs); 
}
void _ppDbgWarning(const char* msg, ...){
va_list vargs;
  va_start(vargs, msg);
  do_dbg_msg("WARNING", msg, vargs);
  va_end(vargs); 
}

void _ppDbgFatalError(const char* msg, ...){
va_list vargs;
  va_start(vargs, msg);
  do_dbg_msg("ERROR", msg, vargs);
  va_end(vargs); 
  ppShutdown();
  exit(1);
}

#else

void do_msg(const char* type, const char* msg, va_list vargs){
  fprintf(outfile, "\n%s:\n\t", type);
  vfprintf(outfile, msg, vargs);
}


void _ppWarning(const char* msg, ...){
va_list vargs;
  va_start(vargs, msg);
  do_msg("WARNING", msg, vargs);
  va_end(vargs); 
}

void _ppFatalError(const char* msg, ...){
va_list vargs;
  va_start(vargs, msg);
  do_msg("ERROR", msg, vargs);
  va_end(vargs); 
  ppShutdown();
  exit(1);
}


#endif  /*! PP_DEBUG*/


#undef outfile


#ifdef PP_DEBUG

/*****************************
  Other little classes
***/
void ppLinkCounted::dbDump(FILE* out)const
{
  ppBase::dbDump(out);
  fprintf(out, "Link count=%d\n", link_count);
}

#endif /*!PP_DEBUG*/

/****************************
  Startup & Shutdown
***/


/***********
  Parses command line, uses getopt like format.  For now customizaton is
  done by just hacking this function.  Unhandled arguments
  are returned in argv.

  Hmmm, I suppose all this should be changed, and made to used
  getpot.
**/
int parse_command_line(int *argc_ret, char** argv){
#if 0
int argc=*argc_ret, arg=0, unhandled=1;
char* ch;

  while(++arg < argc){
    ch=argv[arg];
    switch(*ch){

      /*
        We have a switch or long opiton
      */
      case '-':
        switch(*++ch){
          //long option
          case '-': 
            if(handle_long_option(++ch) < 0)goto cant_handle;
            break;

          default: goto cant_handle;
        
        }
        break;

      cant_handle:
      default:
        //don't know what to do, skip and pass on to user.
        argv[unhandled++]=argv[arg];
        
    } /*main switch*/
  }/*main loop*/

  *argc_ret = unhandled;
#endif //0
  return 0;
}


int ppInit(int *argc_ret, char** argv)
{
  /*
    Parse the command line first.  Even if we have configuration
    files we must do this first in case the config filename is
    defined on the command line.
  */
  if(parse_command_line(argc_ret, argv)<0)
    ppWarning(_PP_FUNCTION_NAME, "Invalid input line");

  return 0;
};

//FIX: this should be called automatically on exit.
void ppShutdown() 
{
}
