/*
 *
 * This file contains the main parts of the PenguinPlay Layer O event
 * mechanism (the messaging system)
 *
 * It's currently almost a 1:1 copy of the code developed by the Gtk--
 * team with some cosmetic changes to better fit into the PPlay
 * naming system. Oh, yes, I added some comments describing its inner
 * workings.
 *
 * The original code was developed by:
 *
 *                    Elliot Lee <sopwith@redhat.com>
 *                    Phil Dawes
 *                    Tero Pulkkinen <terop@modeemi.cs.tut.fi>
 *
 * As of this writing, the Gtk-- homepage is at
 *
 *       http://www.cs.tut.fi/~p150650/gtk/gtk--.html
 *
 * Many thanks to them for this lovely piece of code.
 *
 *
 * The maintainer of this (PenguinPlay) version is currently
 * Christian Reiniger <warewolf@mayn.de>
 *
 *
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef PENGUINPLAY_MESSAGE_MAIN_H
#define PENGUINPLAY_MESSAGE_MAIN_H


template <class rettype>
class ppMsgAbstractSlot0 : public ppMsgConnection
{
public:
	virtual rettype call () = 0;
};




template<class rettype>
class ppMessage0_r
{
private:
	ppMessageList connectionlist;

public:
	void insert_connection (ppMsgAbstractSlot0<rettype>* slot)
	{
		connectionlist.insert(slot);
	}

	rettype operator() ()
	{
		ppMsgConnection *c = connectionlist.begin ();

		while (c != connectionlist.end ())
		{
			( (ppMsgAbstractSlot0<rettype>*)c )->call ();
			c = c->next;
		}
	}
};



class ppMessage0 : public ppMessage0_r<void> { };







// this is for C++ signal connected to C++ slot

template<class rettype,class T>
class ppMsgConcreteOSlot0 : public ppMsgAbstractSlot0<rettype>
{
private:
	T* obj;
	rettype (T::*method) ();

public:
	ppMsgConcreteOSlot0 (T* receiver, rettype (T::*met) ())
		: obj (receiver), method (met)
	{}

	rettype call ()
	{ SP_RETURN (obj->*method) (); }
};





// this is for C++ signal connected to C++ slot
// (specialized version for void return type
#ifdef HAVE_PARTIAL_SPECIALIZATION
template<class T>
class ppMsgConcreteOSlot0<void,T> : public ppMsgAbstractSlot0<void>
{
private:
	T* obj;
	void (T::*method) ();

public:
	ppMsgConcreteOSlot0 (T* receiver, void (T::*met) ())
		: obj (receiver), method (met)
	{}

	void call()
	{ (obj->*method) (); }
};
#endif




template<class rettype, class T>
ppMsgCHandle ppMsgConnectToMethod (ppMessage0_r<rettype> &message,
				   T* receiver,
				   rettype (T::*method) ())
{
	ppMsgConcreteOSlot0<rettype, T> *slot = new ppMsgConcreteOSlot0<rettype, T> (receiver, method);
	message.insert_connection (slot);
	receiver->insert_connection (slot);
	return ppMsgCHandle (slot);
}




template<class T>
ppMsgCHandle ppMsgConnectToMethod (ppMessage0 &message,
				   T* receiver,
				   void (T::*method) ())
{
	ppMsgConcreteOSlot0<void, T> *slot = new ppMsgConcreteOSlot0<void, T> (receiver, method);
	message.insert_connection (slot);
	receiver->insert_connection (slot);
	return ppMsgCHandle (slot);
}







// ------------------------------------------------ same with cbdata
// this is for C++ message connected to C++ slot

template<class rettype,class T, class E>
class ppMsgConcreteOSlot0cb : public ppMsgAbstractSlot0<rettype>
{
private:
	T* obj;
	rettype (T::*method) (E);
	E cbdata;

public:
	ppMsgConcreteOSlot0cb (T* receiver, rettype (T::*met) (E), E cbd)
		: obj (receiver), method (met), cbdata (cbd)
	{}

	rettype call ()
	{ SP_RETURN (obj->*method) (cbdata); }
};





// specialized version for void return type
#ifdef HAVE_PARTIAL_SPECIALIZATION
template<class T, class E>
class ppMsgConcreteOSlot0cb<void,T,E> : public ppMsgAbstractSlot0<void>
{
private:
	T* obj;
	void (T::*method) (E);
	E cbdata;

public:
	ppMsgConcreteOSlot0cb (T* receiver, void (T::*met) (E), E cbd)
		: obj (receiver), method (met), cbdata (cbd)
	{}

	void call ()
	{ (obj->*method) (cbdata); }
};
#endif




template<class rettype, class T, class E>
ppMsgCHandle ppMsgConnectToMethod (ppMessage0_r<rettype> &message,
				   T* receiver,
				   rettype (T::*method) (E),
				   E cbd)
{
	ppMsgAbstractSlot0<rettype> *slot = new ppMsgConcreteOSlot0cb<rettype, T, E> (receiver, method, cbd);
	message.insert_connection (slot);
	receiver->insert_connection (slot);
	return ppMsgCHandle (slot);
}





template<class T, class E>
ppMsgCHandle ppMsgConnectToMethod (ppMessage0 &message,
				   T* receiver,
				   void (T::*method) (E),
				   E cbd)
{
	ppMsgAbstractSlot0<void> *slot = new ppMsgConcreteOSlot0cb<void, T, E> (receiver, method, cbd);
	message.insert_connection (slot);
	receiver->insert_connection (slot);
	return ppMsgCHandle (slot);
}







// -------------------------------------- without cbdata
// C++ message connected to static function

template<class rettype,class M>
class ppMsgConcretePSlot0 : public ppMsgAbstractSlot0<rettype>
{
private:
	M func;

public:
	ppMsgConcretePSlot0(M func_) : func(func_)
	{ }

	rettype call ()
	{ SP_RETURN func (); }

//	static rettype callback (GtkWidget *, ppMsgConcretePSlot0<rettype,M>* s)
//	{ SP_RETURN s->call (); }
};




#ifdef HAVE_PARTIAL_SPECIALIZATION
template<class M>
class ppMsgConcretePSlot0<void,M> : public ppMsgAbstractSlot0<void>
{
private:
	M func;
public:
	ppMsgConcretePSlot0 (M func_) : func(func_)
	{ }

	void call ()
	{ func (); }

//	static void callback (GtkWidget *, ppMsgConcretePSlot0<void,M>* s)
//	{ s->call (); }
};
#endif




template<class rettype>
ppMsgCHandle ppMsgConnectToFunction (ppMessage0_r<rettype> &message,
				     rettype (*func) ())
{
	ppMsgConcretePSlot0<rettype, rettype(*) ()> *slot = new ppMsgConcretePSlot0<rettype, rettype(*) ()> (func);
	message.insert_connection (slot);
	return ppMsgCHandle (slot);
}




template<class rettype, class M>
ppMsgCHandle ppMsgConnectToMessage (ppMessage0_r<rettype> &message,
				    M& func)
{
	ppMsgConcretePSlot0<rettype, M&> *slot = new ppMsgConcretePSlot0<rettype, M&> (func);
	message.insert_connection (slot);
	return ppMsgCHandle (slot);
}




ppMsgCHandle ppMsgConnectToFunction (ppMessage0 &message,
				     void (*func) () )
{
	ppMsgConcretePSlot0<void, void(*) ()> *slot = new ppMsgConcretePSlot0<void, void(*) ()> (func);
	message.insert_connection (slot);
	return ppMsgCHandle (slot);
}





// a function object wrapper.
template<class M>
ppMsgCHandle ppMsgConnectToMessage (ppMessage0 &message,
				    M &func)
{
	ppMsgConcretePSlot0<void, M&> *slot = new ppMsgConcretePSlot0<void, M&> (func);
	message.insert_connection (slot);
	return ppMsgCHandle (slot);
}






// -------------------------------------- with cbdata

template<class rettype, class M, class E>
class ppMsgConcretePSlot0cb : public ppMsgAbstractSlot0<rettype>
{
private:
	M func;
	E cbdata;

public:
	ppMsgConcretePSlot0cb (M func_, E cbd)
		: func (func_), cbdata (cbd)
	{ }

	rettype call ()
	{ SP_RETURN func (cbdata); }

//	static rettype callback (GtkWidget *, ppMsgConcretePSlot0cb<rettype, M, E>* s)
//	{ SP_RETURN s->call (); }
};



#ifdef HAVE_PARTIAL_SPECIALIZATION

template<class M, class E>
class ppMsgConcretePSlot0cb<void,M,E> : public ppMsgAbstractSlot0<void>
{
private:
	M func;
	E cbdata;

public:
	ppMsgConcretePSlot0cb (M func_, E cbd)
		: func (func_), cbdata (cbd)
	{ }

	void call ()
	{ func (cbdata); }

//	static void callback (GtkWidget *, ppMsgConcretePSlot0cb<void,M,E>* s)
//	{ s->call (); }
};
#endif




template<class rettype,class E>
ppMsgCHandle ppMsgConnectToFunction (ppMessage0_r<rettype> &message,
				     rettype (*func) (E),
				     E cbd)
{
	ppMsgConcretePSlot0cb<rettype,rettype (*) (E), E> *slot = new ppMsgConcretePSlot0cb<rettype,rettype(*) (E), E> (func,cbd);
	message.insert_connection (slot);
	return ppMsgCHandle (slot);
}



template<class rettype, class M,class E>
ppMsgCHandle ppMsgConnectToMessage (ppMessage0_r<rettype> &message,
				    M& func,
				    E cbd)
{
	ppMsgConcretePSlot0cb<rettype,M&,E> *slot = new ppMsgConcretePSlot0cb<rettype,M&,E> (func,cbd);
	message.insert_connection (slot);
	return ppMsgCHandle (slot);
}


template<class E>
ppMsgCHandle ppMsgConnectToFunction (ppMessage0 &message,
				     void (*func) (E),
				     E cbd)
{
	ppMsgConcretePSlot0cb<void,void(*) (E),E> *slot = new ppMsgConcretePSlot0cb<void,void(*) (E),E> (func,cbd);
	message.insert_connection (slot);
	return ppMsgCHandle (slot);
}



template<class E, class M>
ppMsgCHandle ppMsgConnectToMessage (ppMessage0 &message,
				    M& func,
				    E cbd)
{
	ppMsgConcretePSlot0cb<void,M&,E> *slot = new ppMsgConcretePSlot0cb<void,M&,E> (func,cbd);
	message.insert_connection (slot);
	return ppMsgCHandle (slot);
}



#define COMMA ,

#define SIGNALS_IMPL(NUM,CB,TEMPLATE_PARAM,ARG_BOTH,ARG_TYPE,ARG_NAME) \
		     \
template<class rettype, TEMPLATE_PARAM> \
class ppMsgAbstractSlot##NUM : public ppMsgConnection { \
public: \
  virtual rettype call(ARG_BOTH)=0; \
}; \
\
template<class rettype,TEMPLATE_PARAM> \
class ppMessage##NUM##_r { \
  ppMessageList connectionlist; \
public: \
  void insert_connection(ppMsgAbstractSlot##NUM<rettype,ARG_TYPE>* slot) { \
    connectionlist.insert(slot); \
  } \
  rettype operator()(ARG_BOTH) { \
    ppMsgConnection *c=connectionlist.begin(); \
    while(c!=connectionlist.end()) { \
      ( (ppMsgAbstractSlot##NUM<rettype,ARG_TYPE>*)c )->call(ARG_NAME); \
      c=c->next; \
    } \
  } \
}; \
template<TEMPLATE_PARAM> \
class ppMessage##NUM : public ppMessage##NUM##_r<void, ARG_TYPE> { };





#define C_SIGNALS_IMPL(NUM,CB,TEMPLATE_PARAM,ARG_BOTH,ARG_TYPE,ARG_NAME,COMMA_CLASS_E,COMMA_E,COMMA_E_PTR,COMMA_E_PTR_ARG,COMMA_ARG,C_ARG,C_VAR,C_DATA) \
template<class rettype,class T,TEMPLATE_PARAM COMMA_CLASS_E> \
class ppMsgConcreteOSlot##NUM##CB : public ppMsgAbstractSlot##NUM<rettype,ARG_TYPE> { \
private: \
  T* obj; \
  rettype (T::*method)(ARG_TYPE COMMA_E_PTR); \
  C_VAR \
public: \
  ppMsgConcreteOSlot##NUM##CB(T* receiver, rettype (T::*met)(ARG_TYPE COMMA_E_PTR) COMMA_E_PTR_ARG) \
    : obj(receiver), method(met) C_ARG {} \
  rettype call(ARG_BOTH) { VR_RETURN (obj->*method)(ARG_NAME C_DATA); } \
}; \
\
template<class rettype,class T,class T1, TEMPLATE_PARAM COMMA_CLASS_E> \
ppMsgCHandle \
ppMsgConnectToMethod(ppMessage##NUM##_r<rettype,ARG_TYPE> &message, \
	T* receiver, rettype (T1::*method)(ARG_TYPE COMMA_E_PTR) COMMA_E_PTR_ARG) \
{ \
  ppMsgAbstractSlot##NUM<rettype,ARG_TYPE> *slot= \
    new ppMsgConcreteOSlot##NUM##CB<rettype,T,ARG_TYPE COMMA_E>(receiver,method COMMA_ARG); \
  message.insert_connection(slot); \
  receiver->insert_connection(slot); \
  return ppMsgCHandle(slot); \
} \
template<class T,class T1, TEMPLATE_PARAM COMMA_CLASS_E> \
ppMsgCHandle \
ppMsgConnectToMethod(ppMessage##NUM##<ARG_TYPE> &message, \
	T* receiver, void (T1::*method)(ARG_TYPE COMMA_E_PTR) COMMA_E_PTR_ARG) \
{ \
  ppMsgAbstractSlot##NUM<void,ARG_TYPE> *slot= \
    new ppMsgConcreteOSlot##NUM##CB<void,T,ARG_TYPE COMMA_E>(receiver,method COMMA_ARG); \
  message.insert_connection(slot); \
  receiver->insert_connection(slot); \
  return ppMsgCHandle(slot); \
} \
\
template<class rettype, class M,TEMPLATE_PARAM COMMA_CLASS_E> \
class ppMsgConcretePSlot##NUM##CB : public ppMsgAbstractSlot##NUM<rettype,ARG_TYPE> { \
private: \
  M func;\
  C_VAR \
public: \
  ppMsgConcretePSlot##NUM##CB(M func_ COMMA_E_PTR_ARG) \
    : func(func_) C_ARG { } \
  rettype call(ARG_BOTH) { VR_RETURN func(ARG_NAME C_DATA); } \
}; \
\
template<class rettype,TEMPLATE_PARAM COMMA_CLASS_E> \
ppMsgCHandle \
ppMsgConnectToFunction(ppMessage##NUM##_r<rettype,ARG_TYPE> &message, \
	rettype (*func)(ARG_TYPE COMMA_E_PTR) COMMA_E_PTR_ARG) { \
  ppMsgConcretePSlot##NUM##CB<rettype,rettype(*)(ARG_TYPE COMMA_E_PTR),ARG_TYPE COMMA_E> *slot= \
    new ppMsgConcretePSlot##NUM##CB<rettype,rettype(*)(ARG_TYPE COMMA_E_PTR),ARG_TYPE COMMA_E>(func COMMA_ARG); \
  message.insert_connection(slot); \
  return ppMsgCHandle(slot); \
}\
template<TEMPLATE_PARAM COMMA_CLASS_E> \
ppMsgCHandle \
ppMsgConnectToFunction(ppMessage##NUM<ARG_TYPE> &message, \
	void (*func)(ARG_TYPE COMMA_E_PTR) COMMA_E_PTR_ARG) { \
  ppMsgConcretePSlot##NUM##CB<void,void (*)(ARG_TYPE COMMA_E_PTR),ARG_TYPE COMMA_E> *slot= \
    new ppMsgConcretePSlot##NUM##CB<void,void(*)(ARG_TYPE COMMA_E_PTR),ARG_TYPE COMMA_E>(func COMMA_ARG); \
  message.insert_connection(slot); \
  return ppMsgCHandle(slot); \
} \
\
\
template<class rettype,class M,TEMPLATE_PARAM COMMA_CLASS_E> \
ppMsgCHandle \
ppMsgConnectToMessage(ppMessage##NUM##_r<rettype,ARG_TYPE> &message, \
	M& func COMMA_E_PTR_ARG) { \
  ppMsgConcretePSlot##NUM##CB<rettype,M&,ARG_TYPE COMMA_E> *slot= \
    new ppMsgConcretePSlot##NUM##CB<rettype,M&,ARG_TYPE COMMA_E>(func COMMA_ARG); \
  message.insert_connection(slot); \
  return ppMsgCHandle(slot); \
}\
template<class M,TEMPLATE_PARAM COMMA_CLASS_E> \
ppMsgCHandle \
ppMsgConnectToMessage(ppMessage##NUM<ARG_TYPE> &message, \
	M& func COMMA_E_PTR_ARG) { \
  ppMsgConcretePSlot##NUM##CB<void,M &,ARG_TYPE COMMA_E> *slot= \
    new ppMsgConcretePSlot##NUM##CB<void,M&,ARG_TYPE COMMA_E>(func COMMA_ARG); \
  message.insert_connection(slot); \
  return ppMsgCHandle(slot); \
}



SIGNALS_IMPL(1,,class P1,
	     P1 p,
	     P1,
	     p)

C_SIGNALS_IMPL(1,,class P1,
	     P1 p,
	     P1,
	     p,
	     ,,,,,,,)

C_SIGNALS_IMPL(1,cb,class P1,
  	     P1 p,
  	     P1,
  	     p,
COMMA class E,COMMA E,COMMA E,COMMA E cbd,COMMA cbd,COMMA cbdata(cbd),
E cbdata;,COMMA cbdata)



SIGNALS_IMPL(2,,class P1 COMMA class P2,
	     P1 p1 COMMA P2 p2,
	     P1 COMMA P2,
	     p1 COMMA p2)

C_SIGNALS_IMPL(2,,class P1 COMMA class P2,
	     P1 p1 COMMA P2 p2,
	     P1 COMMA P2,
	     p1 COMMA p2,
	     ,,,,,,,)

C_SIGNALS_IMPL(2,cb,class P1 COMMA class P2,
	     P1 p1 COMMA P2 p2,
	     P1 COMMA P2,
	     p1 COMMA p2,
COMMA class E,COMMA E,COMMA E,COMMA E cbd,COMMA cbd,COMMA cbdata(cbd),
E cbdata;,COMMA cbdata)

SIGNALS_IMPL(3,,class P1 COMMA class P2 COMMA class P3,
	     P1 p1 COMMA P2 p2 COMMA P3 p3,
	     P1 COMMA P2 COMMA P3,
	     p1 COMMA p2 COMMA p3)

C_SIGNALS_IMPL(3,,class P1 COMMA class P2 COMMA class P3,
	     P1 p1 COMMA P2 p2 COMMA P3 p3,
	     P1 COMMA P2 COMMA P3,
	     p1 COMMA p2 COMMA p3,
	     ,,,,,,,)

C_SIGNALS_IMPL(3,cb,class P1 COMMA class P2 COMMA class P3,
	     P1 p1 COMMA P2 p2 COMMA P3 p3,
	     P1 COMMA P2 COMMA P3,
	     p1 COMMA p2 COMMA p3,
COMMA class E,COMMA E,COMMA E,COMMA E cbd,COMMA cbd,COMMA cbdata(cbd),
E cbdata;,COMMA cbdata)

SIGNALS_IMPL(4,,class P1 COMMA class P2 COMMA class P3 COMMA class P4,
	     P1 p1 COMMA P2 p2 COMMA P3 p3 COMMA P4 p4,
	     P1 COMMA P2 COMMA P3 COMMA P4,
	     p1 COMMA p2 COMMA p3 COMMA p4)

C_SIGNALS_IMPL(4,,class P1 COMMA class P2 COMMA class P3 COMMA class P4,
	     P1 p1 COMMA P2 p2 COMMA P3 p3 COMMA P4 p4,
	     P1 COMMA P2 COMMA P3 COMMA P4,
	     p1 COMMA p2 COMMA p3 COMMA p4,
	     ,,,,,,,)

C_SIGNALS_IMPL(4,cb,class P1 COMMA class P2 COMMA class P3 COMMA class P4,
	     P1 p1 COMMA P2 p2 COMMA P3 p3 COMMA P4 p4,
	     P1 COMMA P2 COMMA P3 COMMA P4,
	     p1 COMMA p2 COMMA p3 COMMA p4,
COMMA class E,COMMA E,COMMA E,COMMA E cbd,COMMA cbd,COMMA cbdata(cbd),
E cbdata;,COMMA cbdata)

SIGNALS_IMPL(5,,class P1 COMMA class P2 COMMA class P3 COMMA class P4 COMMA class P5,
	     P1 p1 COMMA P2 p2 COMMA P3 p3 COMMA P4 p4 COMMA P5 p5,
	     P1 COMMA P2 COMMA P3 COMMA P4 COMMA P5,
	     p1 COMMA p2 COMMA p3 COMMA p4 COMMA p5)

C_SIGNALS_IMPL(5,,class P1 COMMA class P2 COMMA class P3 COMMA class P4 COMMA class P5,
	     P1 p1 COMMA P2 p2 COMMA P3 p3 COMMA P4 p4 COMMA P5 p5,
	     P1 COMMA P2 COMMA P3 COMMA P4 COMMA P5,
	     p1 COMMA p2 COMMA p3 COMMA p4 COMMA p5,
	     ,,,,,,,)

C_SIGNALS_IMPL(5,cb,class P1 COMMA class P2 COMMA class P3 COMMA class P4 COMMA class P5,
	     P1 p1 COMMA P2 p2 COMMA P3 p3 COMMA P4 p4 COMMA P5 p5,
	     P1 COMMA P2 COMMA P3 COMMA P4 COMMA P5,
	     p1 COMMA p2 COMMA p3 COMMA p4 COMMA p5,
COMMA class E,COMMA E,COMMA E,COMMA E cbd,COMMA cbd,COMMA cbdata(cbd),
E cbdata;,COMMA cbdata)



#undef COMMA
#undef CALLBACK_IMPL
#undef SIGNALS_IMPL
#undef C_SIGNALS_IMPL

#endif
/*  static rettype callback(GtkWidget *, ARG_BOTH, ppMsgConcretePSlot##NUM##CB<rettype,M,ARG_TYPE COMMA_E>* s) { VR_RETURN s->call(ARG_NAME); }\

 */
