/*
 *
 * This is the main header file of PenguinPlay's layer O event mechanism
 * (I'll talk of it as the "messaging system" to avoid confusion with
 * the layer P event mechanism).
 *
 * It's currently almost a 1:1 copy of the code developed by the Gtk--
 * team with some cosmetic changes to better fit into the PPlay
 * naming system. Oh, yes, I added some comments describing its inner
 * workings.
 *
 * The original code was developed by:
 *
 *                    Elliot Lee <sopwith@redhat.com>
 *                    Phil Dawes
 *                    Tero Pulkkinen <terop@modeemi.cs.tut.fi>
 *
 * As of this writing, the Gtk-- homepage is at
 *
 *       http://www.cs.tut.fi/~p150650/gtk/gtk--.html
 *
 * Many thanks to them for this lovely piece of code.
 *
 *
 * The maintainer of this (PenguinPlay) version is currently
 * Christian Reiniger <warewolf@mayn.de>
 *
 *
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
  Some documentation on usage of messages:

  Each message is represented in the class hierarchy with a function
  object of the message's name. This function object provides way to emit
  the message by calling it and handles the connections that can be made
  between it and other static and member functions.
  If you get compiler errors while trying to use it, there most probably is
  something wrong with your message's argument types - check your header
  file for exact types needed.

  class mySenderClass
  {
  public:
     ppMessage2<int,float> outputmessage;
       // this object will do outputmessage(10,50.2)
       // and outside people can connect some function etc to
       // the message to trap the call
       //
       // 2 == number of arguments
       // <int,float> == types of arguments

  private:
     void foo() { outputmessage (10,50.2); } // calls a message
  };


  class myReceiverClass
   : public virtual ppMessageBase
   // this implements some functions the messaging system calls
   // It's needed for every class that should be able to receive
   // messages.

  {
  public:
     // you can connect messages to this method
     void fooimpl(int a, float f)
     {
       // use a and f here
     }
  };


  connections can be created like this:

   mySenderClass   Sender;
   myReceiverClass Receiver;
   void static_function(int a, float b);

   // we specify here the message, receiving object and function inside
   // receiving object

   ppMsgConnectToMethod   (Sender.outputmessage, &Receiver, &myReceiverClass::fooimpl); // connect to member function
   ppMsgConnectToFunction (Sender.outputmessage, &static_function);      // connect to static function

   ppMsgCHandle cc = ppMsgConnectToMethod (Sender.outputmessage, &Receiver, &myReceiverClass::fooimpl);
   ..
   cc.disconnect(); // we can also disconnect messages at runtime when
                    // needed - If ppMsgCHandle-object is copied, the
		    // old one loses its ability to disconnect -- i.e. works
		    // like auto_ptr.

 */


#ifndef PENGUINPLAY_MESSAGE_H
#define PENGUINPLAY_MESSAGE_H 1


#include <PenguinPlay/PenguinPlay.h>     // PP-wide type declarations etc


#include <PenguinPlay/message_common.h>
#include <PenguinPlay/message_main.h>
#include <PenguinPlay/message_gateway.h>



#endif