/****************************************************
  PenguinPlay.h:

  This header defines types and utilitly functions the
  PenguinPlay Game Development Kit.

  I the following on this file ages ago.  It doesn't make sense.

  "This file (but not all of PenguinPlay) is in the public domain, so
  feel free to do whatever you like to it (except copyright it)."

  No here are the rules:

     This file (but not all of PenguinPlay) is  copyright (C), Adrian
	 Ratnapala 1998. You are given permission to use, modify or distribute
	 it for whatever reason.  If you distribute modified versions you
	 must display the fact that it has been modified and the nature
	 of those modifications.

  OK: One of the two above copyright notecies is valid.  At the end
  of the day it doesn't make much difference.
***/

#ifndef _PenguinPlay_h
#define _PenguinPlay_h


#define PENGUINPLAY_VERSION_MAJOR 0
#define PENGUINPLAY_VERSION_MINOR 0

#include <config.h>

#ifdef HAVE_UNISTD_H
#  define _PP_POSIX
#  include <unistd.h>
#else
#  error "POSIX functionality currently needed"
#endif

#include <limits.h>
#include <stdio.h>

/***************************************
*
*  Examine our environment.
*
**************************************/

/***
  What's that bit of silicon under us?
***/

#ifndef _PP_ARCH_GENERIC /*For unknown architectures or testing*/

#if defined(__386__) || defined(i386)
  #define _PP_ARCH_I386
#endif /*386 Architecture*/

#endif /*!_PP_ARCH_GENERIC*/

/***
  What language are we using?
***/
#if defined(__cplusplus) || defined(c_plusplus)
  #define _PP_CPLUSPLUS
#else
#define _PP_C
#endif


/***
  Do 64 bit integers exist?
  Thanks Yong Chi for the hack for detecting
  64 bit architectures.
***/

#if INT_MAX < LONG_MAX
  #define _PP_64BIT_ARCH
  #define _PP_64BIT_INTS
#elif defined (__GNUC__)
  #define _PP_64BIT_INTS
#endif


/*[en|disable] some GCC specifics*/
#ifdef __GNUC__
#else /*!GNUC*/
  #define __attribute__(ARG)
#endif /*!GNUC*/



/*
  Handle alloca: this probably needs fixing when we port.
*/
#ifdef HAVE_ALLOCA
  #define _PP_ALLOCA alloca
  #define _PP_DEALLOCA(PTR)
#else /*!HAVE_ALLOCA*/
  #define _PP_ALLOCA malloc
  #define _PP_DEALLOCA(PTR) free(PTR)
#endif


/***************************************
*
*  Miscilaneus definitions
*
**************************************/

#ifdef _PP_CPLUSPLUS
  #define _PP_EXTC extern "C"
#else
  #define _PP_EXTC extern
#endif




/***************************************
*
*  Types and constants
*
**************************************/


/***
  Old favourites.
***/

/*
  Always felt that defining all these types is a bit excessive.
  But it seems like standard practice, so I'll do it anyway.
  (Besides, these are about the only original fragment of the
  sources I inherited from Steve Baker, so I'll keep them for
  nostalgic reasons:) )
*/
#ifdef _PP_CPLUSPLUS
typedef          bool     ppBool   ;
#else
typedef          int      ppBool   ;
#endif

typedef unsigned char     ppByte  ;


/***
  Integers with guaranteed _minimum_ size.
  These could be larger than you expect,
  they are designed for speed.
***/
typedef          long int      ppInt32;
typedef          long int      ppInt16;
typedef          long int      ppInt8;
typedef unsigned long int      ppuInt32;
typedef unsigned long int      ppuInt16;
typedef unsigned long int      ppuInt8;

/*64 bits ints might exist.  Preferably becuase this is a 64
  bit architecture, but we will use the GCC long long type if we
  have to.
*/
#ifdef _PP_64BIT_INTS
#ifdef _PP_64BIT_ARCH
  typedef              long ppInt64;
  typedef  unsigned    long ppuInt64;
#elif defined(__GNUC__)
  typedef           long long ppInt64;
  typedef  unsigned long long ppuInt64;
#endif
#endif


/***
  Integers with guaranteed _exact_ size.
***/
typedef          int      pp32;
typedef          short    pp16;
typedef signed   char     pp8;
typedef unsigned int      ppu32;
typedef unsigned short    ppu16;
typedef unsigned char     ppu8;
#ifdef _PP_64BIT_INTS
#ifdef _PP_64BIT_ARCH
  typedef              long pp64;
  typedef  unsigned    long ppu64;
#elif __GNUC__
  typedef          long long pp64;
  typedef unsigned long long ppu64;
#endif
#endif


/**
  This is used in the debugging versions of the messaging
  functions.
**/
#ifdef __GNUC__
  #define _PP_FUNCTION_NAME __PRETTY_FUNCTION__
#else
  extern const char* _ppNoFuncNameMsg;
  #define _PP_FUNCTION_NAME _ppNoFuncNameMsg;
#endif




/***************************************
*
*  Miscilaneus library functions.
*
**************************************/

/***
  Intializes the library with aid of command line.

  Unused options are returned in argv.  No stupid rules saying that argc
  and argv must be the real ones, make them up if you like.
***/
_PP_EXTC int ppInit (int* argc, char** argv) ;


/***
  I think we should just let the user use exit()
***/
_PP_EXTC void ppShutdown () ;



/***************************************
*
*  Debugging stuff.
*
**************************************/

/*Debugging messages only if debugging is compiled in*/
#ifdef PP_DEBUG
  /*_ppSetLineNum(__LINE), _ppSet*/
  _PP_EXTC void _ppDbgDebug(const char* msg, ...)
    __attribute__((__format__(printf, 1, 2)));
  _PP_EXTC void _ppDbgWarning(const char* msg, ...)
    __attribute__((__format__(printf, 1, 2)));
  _PP_EXTC void _ppDbgFatalError(const char* msg, ...)
    __attribute__((__format__(printf, 1, 2)));

  /*like ppDebug but without line info*/
  _PP_EXTC void ppDbgPrint(const char* msg, ...)
    __attribute__((__format__(printf, 1, 2)));

  _PP_EXTC int* _pp_db_lineno_loc(void);
  _PP_EXTC char** _pp_db_file_loc(void);
  _PP_EXTC char** _pp_db_func_loc(void);

  #define ppDebug (\
      *_pp_db_lineno_loc()=__LINE__,\
      *_pp_db_file_loc()=__FILE__,\
      *_pp_db_func_loc()=_PP_FUNCTION_NAME,\
       _ppDbgDebug\
  )
  #define ppWarning (\
      *_pp_db_lineno_loc()=__LINE__,\
      *_pp_db_file_loc()=__FILE__,\
      *_pp_db_func_loc()=_PP_FUNCTION_NAME,\
       _ppDbgWarning\
  )
  #define ppFatalError (\
       *_pp_db_lineno_loc()=__LINE__,\
       *_pp_db_file_loc()=__FILE__,\
       *_pp_db_func_loc()=_PP_FUNCTION_NAME,\
        _ppDbgFatalError\
  )

#else /*PP_DEBUG*/
  _PP_EXTC void _ppWarning(const char* msg, ...)
    __attribute__((__format__(printf, 1, 2)));
  _PP_EXTC void _ppFatalError(const char* msg, ...)
    __attribute__((__format__(printf, 1, 2)));

  #define ppDebug (void)
  #define ppWarning _ppWarning
  #define ppFatalError _ppFatalError
  #define ppDbgPrint (void)
#endif /*!PP_DEBUG*/





#endif /*_PenguinPlay_h*/
