/****************************************************
  LayerO.h:

  This header defines types and utilitly macros used by
  the C++ Layer O of the PenguinPlay Game Development Kit.

     This file (but not all of PenguinPlay) is  copyright (C), Adrian
	 Ratnapala 1998. You are given permission to use, modify or distribute
	 it for whatever reason.  If you distribute a modified version you
	 must display the fact that it has been modified and the nature
	 of those modifications.
***/


/*FIX: You can see the naeming system is a little dysfunctional.*/
#ifndef _PP_LayerO_h
#define _PP_LayerO_h


#ifndef _PP_CPLUSPLUS
  #error This file should only be included from C++!
#endif



/*
    Utility Definitions.
*/

/*************************
   I for one have hundreds of functions called GetXXX and SetXXX, which
   are just little inlines which access some data member of a class.

   So here are some macros which expand out to be common method declarations.
   I don't think these macros really harm readability.  In fact I think
   they improve it.  We have five types of GETSETS:

     _PP_GETSET:           Accesses a variable in a straigforward way.
	 _PP_GETSET_REF:       Accesses a reference.  Like Java.
	 _PP_GETSET_LINK:      Accesses a link counted object. (ppLinkCounted)
	 _PP_GETSET_VIRTUAL:   Declare GetXXX and SetXXX to be virtual
	 _PP_GETSET_ABSTRACT:  Declare GetXXX and SetXXX to be abstract

   All these are to be used in class definitions.  The first three expand
   to inline functions.

   Also there is:

   _PP_DEFINE_GETSET
   _PP_DEFINE_GETSET_REF
   _PP_DEFINE_GETSET_LINK

   Which can be used in .cc files to create out of line definitions.
   Useful but not required in conjunction with _PP_GETSET_VIRTUAL.

   FIX: We are losing a lot of type safety here.  What if we were to try
   using const_cast things instead of brute force typecasts?
***********************/

/* The following three macros are backends which do the actual work
 * for the _PP_GETSET* macros.
 */
#define _PP__GETSET(NAME, VAR, TYPE, CLASS)\
    TYPE CLASS##Get##NAME ()const        {return (TYPE)VAR;}\
    void CLASS##Set##NAME (const TYPE n) {VAR=(TYPE)n;}

/*as above, but does assignment by reference, rather than value.*/
#define _PP__GETSET_REF(NAME, VAR, TYPE, CLASS)\
    TYPE& CLASS##Get##NAME () const        {return *(TYPE*)VAR;}\
    void  CLASS##Set##NAME (const TYPE& n) {VAR=(TYPE*)&n;}

#define _PP__GETSET_LINK(NAME, VAR, TYPE, CLASS)\
    TYPE& CLASS##Get##NAME ()const         {return *(TYPE*)VAR;}\
    void  CLASS##Set##NAME (TYPE& n) {\
      if(VAR) VAR->Unlink();\
      if( (VAR=&n) ) VAR->Link();\
    }


#define _PP_GETSET(NAME, VAR, TYPE) _PP__GETSET(NAME, VAR, TYPE,)
#define _PP_GETSET_REF(NAME, VAR, TYPE) _PP__GETSET_REF(NAME, VAR, TYPE,)
#define _PP_GETSET_LINK(NAME, VAR, TYPE) _PP__GETSET_LINK(NAME, VAR, TYPE,)



#define _PP__V_GETSET(NAME, TYPE, ABST)\
    virtual TYPE Get##NAME()const ABST ;\
    virtual void Set##NAME(const TYPE n) ABST ;

#define _PP__V_GETSET_REF(NAME, TYPE, ABST)\
    virtual TYPE& Get##NAME()const ABST;\
    virtual void Set##NAME(const TYPE& n) ABST;

#define _PP__V_GETSET_LINK(NAME, TYPE, ABST)\
    virtual TYPE& Get##NAME()const ABST;\
    virtual void Set##NAME(TYPE &n) ABST;


#define _PP_VIRTUAL_GETSET(NAME, TYPE) _PP__V_GETSET(NAME,TYPE,)
#define _PP_VIRTUAL_GETSET_REF(NAME, TYPE) _PP__V_GETSET_REF(NAME,TYPE,)
#define _PP_VIRTUAL_GETSET_LINK(NAME, TYPE) _PP__V_GETSET_LINK(NAME,TYPE,)


#define _PP_ABSTRACT_GETSET(NAME, TYPE) _PP__V_GETSET(NAME, TYPE, =0)
#define _PP_ABSTRACT_GETSET_REF(NAME, TYPE) _PP__V_GETSET_REF(NAME, TYPE, =0)
#define _PP_ABSTRACT_GETSET_LINK(NAME, TYPE) _PP__V_GETSET_LINK(NAME, TYPE, =0)


#define _PP_DEFINE_GETSET(CLASS, NAME, VAR, TYPE)\
	_PP__GETSET(NAME, VAR, TYPE, CLASS##::)

#define _PP_DEFINE_GETSET_REF(CLASS, NAME, VAR, TYPE)\
	_PP__GETSET_REF(NAME, VAR, TYPE, CLASS##::)

#define _PP_DEFINE_GETSET_LINK(CLASS, NAME, VAR, TYPE)\
	_PP__GETSET_LINK(NAME, VAR, TYPE, CLASS##::)



/***
*  ppBase: Base class for everything.  Should do nothing when debugging
*  is not on.
***/

#ifdef PP_DEBUG

/*******************************************
  When debugging is on, we maintain a list of all objects derived from
  ppBase.  We can then get them to
       * give us a string the object.
       * dump their state info to a file.
       * test whether the current state is valid or garbage.
  All this is done by virtual functions with resonable defaults,
  so if you don't want to be bothered with this stuff in your
  own classes, you don't have to be.

  FIX: I don't know what happens when you use multiple inheritance.
*******************************************/
class ppBase {

  ppBase *next, *prev;
  static ppBase *first_object;
  static int next_id;
  int id;

  public:


  /*
   * Stupid funcions for dumping deubging info.
   */

  virtual char* dbGetClassName()const{return "OBJECT";}
  virtual char* dbGetObjectName(char* buf, size_t len)const;
  char* dbLeakyGetObjectName()const
  {
    /*
      Please note, when not debugging, don't use functions
      which knowingly leak memory.
      ofcourse you could just delete the string aftwerwards.
	*/
    return dbGetObjectName(new char[100], 100);
  };

  //this is the only sane one to actuall use.  The two things above
  //it are just cruft. Note: it leeks. (That's the problem with char*).
  static char* dbLeakyGetObjectName(const ppBase& obj){
    static char* Null = "{NULL}";
    if(&obj)return obj.dbLeakyGetObjectName();
	else return strcpy(new char[sizeof(Null)], Null);
  }

  ppBase();

  /*The data in here must not be copied.*/
  ppBase(const ppBase& o){ ppBase(); }
  ppBase& operator = (const ppBase& o){return *this;}

  virtual ~ppBase();


  /*
   * Actuall work
   */
  /*be sure to call the inherited version if you override either of these.*/
  virtual bool dbIntegrityOk()const;
  virtual void dbDump(FILE* out)const;

  /*this does what it names suggest.*/
  static void dbDumpAll(FILE* out);

};

#define _PP_DB_STD_OBJNAME(NAME)

#else

class ppBase {

  public:

  ppBase(){}
  /*DON'T use virtual destructor, that incurrs overhead in unexcpected ways.*/
};


#define _PP_DB_STD_OBJNAME(NAME)

#endif /*PP_DEBUG*/






/****************************
Derive from this class if you want an object to have
its allocation handled by link counts.
****************************/
class ppLinkCounted : public ppBase {
  int link_count;

  public:

 /*
  *  Administrivia
  */

  ppLinkCounted():link_count(0){}

  ppLinkCounted(const ppLinkCounted& o)
  {
    link_count = 0;
  };

  ppLinkCounted& operator=(const ppLinkCounted& o)
  {
    /*this must be a no op to stop the link count from being changed.*/
	return *this;
  }

  #ifdef PP_DEBUG
  virtual void dbDump(FILE* out)const;
  #endif


  /*
   * Real work.
   */

  void Link(){link_count++;}
  void Unlink(){if(!--link_count)delete this;}

  /*
     Descendents need virtual destructors.
     this should enforce that when using egcs.
  virtual ~ppLinkCounted(){}
  */
};





#endif //_PP_LayerO_h
