/*
 * Declaration of PenguinPlay exception types
 *
 * License: See the accompanying file COPYING
 *
 * Last change by $Author: creinig $
 * on             $Date: 1998/10/05 19:08:31 $
 * to             $Revision: 1.4 $
 *
 */


#ifndef __PENGUINPLAY_EXCEPTIONS_H__
#define __PENGUINPLAY_EXCEPTIONS_H__ 1

#include <PenguinPlay/PenguinPlay.h>

using namespace std;


//
// Base exception class.
// Later we might feel the need to make this thing a bit cleverer.
// Update: I tried to improve it - hope this is fine (update from warewolf)
//
class ppException
{
private:

	const char *_Origin;  // Where was it thrown?
	const char *_Type;    // What exception category is it in?
	const char *_Details; // What exactly happened?


public:

	// generic constructor
	ppException (void) :
		_Origin ("unknown"),
		_Type ("Error: Unknown PPlay Exception."),
		_Details ("unknown")
	{}

	// Constructor for custom setting of the fields. Usually called
	// in the initializer list of derived classes
	ppException (const char *origin, const char *type, const char *details) :
	        _Origin (origin),
		_Type (type),
		_Details (details)
	{}



	// Every error of given type has a particular.
	const char *Type    (void) { return _Type;    }

	// These strings should be set on a per construction basis.
	// The constructors of derived exception classes need to set them:
	// ppSomeException::ppSomeException (const char *Org, const char *Det);
	const char *Origin  (void) { return _Origin;  };
	const char *Details (void) { return _Details; };

  //FIX we should perhaps have a "operator<<(ostream&)" function or the like
  //but the corporate will has not yet decided how we handle this.
  //(i.e. we haven't decided between iostream or stdio).
};




// One or more function/method parameter(s) had an invalid value
class ppEInvalidParameter : public ppException
{
public:
	ppEInvalidParameter (const char *origin, const char *details) :
		ppException (origin,
			     "One parameter had an invalid value",
			     details)
	{}

};



// For paranoia tests. Should only be thrown when the code/compiler/OS is buggy
class ppEObscureFailure : public ppException
{
public:
	ppEObscureFailure (const char *origin, const char *details) :
		ppException (origin,
			     "This should never happen",
			     details)
	{}
};



// Thrown when some aspect of the environment is not supported or a required
// "feature" is not present. Note: this is not for checks that can be done at
// compile time.
class ppEUnsupportedEnvironment : public ppException
{
public:
	ppEUnsupportedEnvironment (const char *origin, const char *details) :
		ppException (origin,
			     "This environment is not supported (yet). Please"
			     "send the maintainers a note about this incident",
			     details)
	{}
};



// Thrown e.g. when decoding corrupt files etc
class ppEInvalidData : public ppException
{
public:
	ppEInvalidData (const char *origin, const char *details) :
		ppException (origin,
			     "The data currently processed is invalid",
			     details)
	{}
};



// File opening / memory allocation / visual initialization / ... failed
class ppEAccessFailure : public ppException
{
public:
	ppEAccessFailure (const char *origin, const char *details) :
		ppException (origin,
			     "Attempt to access resource failed",
			     details)
	{}
};


#endif
