/************************************************************************
    ppgLinearSurfaceClass.cc:  Defines ppgLinearSurfaceClass.


    ppgLinearSurfaceClass:
        Holds information common to a group of compatible linear
        surfaces.


    Part of the PenguinPlay 2d library.  Please see LICENSE.TXT supplied
    with this library for copyright details.

    Copyright (C)    Adrian Ratnapala 1998.


    $Author: raka $
    $Date: 1998/11/25 10:06:37 $
    $Revision: 1.1 $
************************************************************************/


#include "ppgCommon.h"
#include <PenguinPlay/ppgLinearDevice.h>
#include <PenguinPlay/ppgLinearCommands.h>
#include <PenguinPlay/ppgGC.h>
#include <PenguinPlay/ppgColour.h>



void ppgLinearDevice::InitializeGC(ppgGC& gc) const
{
  /*
   *And Java thinks it doesn't need a preprocessor.
   */
  #define SET_HANDLER(hand)\
    gc.SetHandler(\
     ppgDrawCmd::dc##hand,\
     (ppgDrawCmd::Handler)ppgLinearDrawCmds::hand\
    )
  #define SET_EMPTY(hand)\
    gc.SetHandler(\
     ppgDrawCmd::dc##hand,\
     (ppgDrawCmd::Handler)ppgDrawCmd::EmptyHandler\
    )
  
  SET_HANDLER(Clear);
  
  SET_EMPTY(SetForeground);
  SET_EMPTY(GetForeground);
  
  SET_EMPTY(SetBackground);
  SET_EMPTY(GetBackground);

  #undef SET_HANDLER
  #define SET_HANDLER(hand, bpp)\
    gc.SetHandler(\
     ppgDrawCmd::dc##hand,\
     (ppgDrawCmd::Handler)ppgLinearDrawCmds::hand##bpp\
    )
 
  switch(GetColourMode().GetDepth()){
    case 32:
      SET_HANDLER(PixBlitRaw, 32);
	  break;
  
    case 16: 
      SET_HANDLER(PixBlitRaw, 16);
      SET_HANDLER(DrawLine, 16);
      break;
      
    default:
      ppDebug("Unknown depth for GC\n");
	  break;
  }


  #undef SET_HANDLER
  #undef SET_EMPTY
};


    
