/************************************************************************
    ppgLinearCommands.cc:  Defines ppgLinearCommands.


    ppgLinearCommands:
        Holds commands for drawing into linear memory buffers.


    Part of the PenguinPlay 2d library.  Please see LICENSE.TXT supplied
    with this library for copyright details.

    Copyright (C)    Adrian Ratnapala 1998.


    $Author: raka $
    $Date: 1998/11/25 10:06:36 $
    $Revision: 1.5 $
************************************************************************/

#include "ppgCommon.h"
#include <PenguinPlay/ppgColour.h>
#include <PenguinPlay/ppgGC.h>
#include <PenguinPlay/ppgLinearCommands.h>

/**************
  These functions are defined outside ppgLinearSurface because
  the draw commands are not strictly part of a ppgSurface.
  (After all the user is allowed to change them at will).
  
  Really these are freestanding functions, but I have made
  them static functions of a class for neatness.  (By golly
  it would be nice if gcc supported namespaces).
****/

#include "ppgCppDefs.inc"
#undef COMMON_ARGS
#define COMMON_ARGS ppgGC& gc, ppgLinearSurface& out



/*
 * Some "vector" drawing things.
 */

//FIX: move this some where else
//FIX: is the assembly really needed.  GCC probably optimizes that
//well anyway.  I should check.
//also check if an int based for loop optimizes better.
inline void memset32(pp32* dest, pp32 word, size_t num)
{
#ifdef _PP_ARCH_I386

  register void  *tmp=(void*) dest;
  asm volatile (
    "cld\n"
    "rep; stosl\n"
    :/*no output*/
    :"c"(num), "D"(tmp), "a"(word)
    :"cx", "di", "memory"
  );
  
#else /*!_PP_ARCH_I386*/

  for(pp32* sentry = dest+num; dest<sentry; dest++)*dest=word;
  
#endif /*_PP_ARCH_UNKNOWN*/
}



#define DEFINE_PIX_BLIT_RAW(BPP)                                           \
  void ppgLinearDrawCmds::PixBlitRaw##BPP(                                 \
                           COMMON_ARGS,                                    \
               	           ppgPixel in,                                    \
                           _PP_POINT_COORDS                                \
                          )                                                \
  {                                                                        \
    *(                                                                     \
      (ppu##BPP*)((ppu8*)out.GetMemBlock() + y*out.GetScanlineSkip()) + x  \
    ) = (ppu##BPP)in;                                                      \
  }


DEFINE_PIX_BLIT_RAW(8)
DEFINE_PIX_BLIT_RAW(16)
DEFINE_PIX_BLIT_RAW(32)



/*
 * Miscilaneaus freinds.
 */

void ppgLinearDrawCmds::Clear(COMMON_ARGS)
{
  ppDebug("Clearing linear surface\n");
}

#undef COORDS
#include "ppgCppUndefs.inc"
