/**********************************************************
	ppgLinearDevice.h: Implement ppgLinearDevice.

	A linear device is a block of memory laid
	out in the obvious manner to represent a
	pixmap.

	Part of the PenguinPlay - 2d library.  Defines Drawing Commands
	for use in this library.  Please LICENSE.TXT supplied with
	this library.

	Copyright (C) 	Adrian Ratnpala 1998.
**********************************************************/


#include <ppgCommon.h>
#include <ppgLinear.h>
#include <ppgLinearCommands.h>
#include <ppgGC.h>


ppgGC& ppgLinearDevice::NewGC()const
{
ppgGC* r_val;

  r_val = new ppgGC(GetColourMode());

  /*
   *And Java thinks it doesn't need a preprocessor.
   */
  #define SET_HANDLER(hand)\
    r_val->SetHandler(\
     ppgDrawCmd::dc##hand,\
     (ppgDrawCmd::Handler)ppgLinearDrawCmds::hand\
    )
  #define SET_EMPTY(hand)\
    r_val->SetHandler(\
     ppgDrawCmd::dc##hand,\
     (ppgDrawCmd::Handler)ppgLinearDrawCmds::Empty\
    )
  
  SET_HANDLER(Clear);
  SET_EMPTY(SetPixel);

  #undef SET_HANDLER
  #define SET_HANDLER(hand, bpp)\
    r_val->SetHandler(\
     ppgDrawCmd::dc##hand,\
     (ppgDrawCmd::Handler)ppgLinearDrawCmds::hand##bpp\
    )
 
  switch(GetColourMode().GetDepth()){
    case 16: 
      SET_HANDLER(DrawLine, 16);
      break;
      
    default:
      ppDebug("Unknown depth for GC\n");
      delete r_val;
      return *((ppgGC*)NULL);
  }


  #undef SET_HANDLER
  #undef SET_EMPTY
  
  return *r_val;
};
