/************************************************************************
    ppgGGICommands.cc:  Defines ppgGGICommands.


    ppgGGICommands:
        Holds commands for drawing into GGI surfaces.


    Part of the PenguinPlay 2d library.  Please see LICENSE.TXT supplied
    with this library for copyright details.

    Copyright (C)    Adrian Ratnapala 1998.


    $Author: raka $
    $Date: 1998/11/25 10:06:29 $
    $Revision: 1.4 $
************************************************************************/

#include "ppgCommon.h"
#include <PenguinPlay/ppgColour.h>
#include <PenguinPlay/ppgGC.h>
#include <PenguinPlay/ppgGGICommands.h>
#include <PenguinPlay/ppgGGISurface.h>

//Just a little thing ease typing and reading.
//FIX: any reason why this isn't an inline function?
//#define GET_DEVICE(gc) ((ppgGGIDevice&) (((ppgGC&)gc).GetDevice()) )
#define GET_DEVICE(gc) ((ppgGGIDevice&) (gc).GetDevice() )

/**************
  These functions are defined outside ppgLinearSurface because
  the draw commands are not strictly part of a ppgSurface.
  (After all the user is allowed to change them at will).
  
  Really these are freestanding functions, but I have made
  them static functions of a class for neatness.  (By golly
  it would be nice if gcc supported namespaces).
****/

#include "ppgCppDefs.inc"


//FIX: this, I think, is wrong.  This is more like waht 
//PixBlitRaw should be doing.
void ppgGGIDrawCmds::PixBlit(
                  COMMON_ARGS, 
                  ppgPixel in, 
                  ppgCoord x, ppgCoord y
				)
{
  ggiPutPixel(
    GET_DEVICE(gc).GetGGIVisual(), 
	x+((ppgGGISurface&)out).GetXPos(),  //FIX, yick, typecasts.
	y+((ppgGGISurface&)out).GetYPos(), 
	(ppgPixel)in
  );
}


void ppgGGIDrawCmds::SetForeground(COMMON_ARGS, ppgPixel new_pixel)
{
  #ifdef _PP_DEBUG
  ppDebug(
    "Setting foreground colour for GC %s to %x\n",
    ppBase::dbLeekyGetObjectName(gc),
    (ppu32)new_pixel
  );
  #endif /*_PP_DEBUG*/
  ggiSetGCForeground( 
    GET_DEVICE(gc).GetGGIVisual(), 
	(ppu32)new_pixel 
  );
}


void ppgGGIDrawCmds::SetBackground(COMMON_ARGS, ppgPixel new_pixel)
{
  #ifdef _PP_DEBUG
  ppDebug(
    "Setting background colour for GC %s to %x\n",
    ppBase::dbLeekyGetObjectName(gc),
    (ppu32)new_pixel
  );
  #endif /*_PP_DEBUG*/
  ggiSetGCBackground( 
    GET_DEVICE(gc).GetGGIVisual(), 
	(ppu32)new_pixel 
  );
}




void ppgGGIDrawCmds::DrawHLine(COMMON_ARGS,ppgCoord x,ppgCoord y,ppgCoord len){
  ggiDrawHLine( 
    GET_DEVICE(gc).GetGGIVisual(), 
	x+((ppgGGISurface&)out).GetXPos(),  //FIX, yick, typecasts.
	y+((ppgGGISurface&)out).GetYPos(), 
        len 
  );
}



#undef COORDS
#include "ppgCppUndefs.inc"
