/************************************************************************
    ppgDevice.cc:  Defines ppgDevice.


    ppgDevice:
        Represents the environment in which a group of compatible surface
        exists. FIX: that is a _really_ vague description.  Not goud
        when you can't describe what one of the classes in your API does.


    Part of the PenguinPlay 2d library.  Please see LICENSE.TXT supplied
    with this library for copyright details.

    Copyright (C)    Adrian Ratnapala 1998.


    $Author: raka $
    $Date: 1998/11/25 10:06:25 $
    $Revision: 1.1 $
************************************************************************/



#include "ppgCommon.h"

#include <PenguinPlay/ppgGC.h>
#include <PenguinPlay/ppgDevice.h>
#include <PenguinPlay/ppgSurface.h>
#include <PenguinPlay/ppgGGIDevice.h>


/************************************************************
 * Administrivia
 */


/*Factory to crate a new device as speficied by the given string.
  string is ignored for now and we just create a GGI device
*/
ppgDevice& ppgNewDevice(const char* specifier)
{
  return *(ppgDevice*) new ppgGGIDevice();
}

ppgDevice::ppgDevice() : 
  default_gc_exists(false), 
  default_gc(NULL),
  colour_mode(NULL),
  main_surface(NULL)
{
}

ppgDevice::~ppgDevice(){
  if(default_gc) delete default_gc;
  if(colour_mode) delete default_gc;
  if(main_surface) delete main_surface;
}



/************************************************************
 * Mode setting
 */

//FIX: This function is either a bell or a whistle, either way,
//we don't really need it.
//so we comment it out and see what happens when next we compile.
//void ppgDisplay::SetDepth(int depth)
//{
//  SetColourDepth(depth);
//  SetBPP(depth);
//}



/************************************************************
 * Miscilaneus
 */

char* ppgDevice::eNoMode::Message(){
  return msg;
}



ppgGC& ppgDevice::NewGC()const
{
  ppgGC& r_val = *(new ppgGC(*this));
  InitializeGC(r_val);
  r_val.SetForegroundAbs(ppgGC::GetDefaultForegroundAbs());
  r_val.SetBackgroundAbs(ppgGC::GetDefaultBackgroundAbs());
  
  return r_val;
}

ppgGC& ppgDevice::GetDefaultGC()const
{
  if( !(default_gc || default_gc_exists) ){
    default_gc = &NewGC();
    default_gc_exists = true;
  }
  return *default_gc;
}

void ppgDevice::SetDefaultGC(ppgGC& n)
{
  if(default_gc)delete default_gc;
  default_gc_exists=true;
  default_gc=&n;
}

//: This ends Device's ownership of GC.
ppgGC& ppgDevice::TakeDefaultGC()       
{
  ppgGC& rval=GetDefaultGC();
  default_gc=NULL;
  default_gc_exists=false;
  return rval;
};


/**********************
* Debugging stuff
********/
#ifdef PP_DEBUG
void ppgDevice::dbDump(FILE* out)const
{
  ppBase::dbDump(out);
  fprintf(out, 
           "Default GC %s\n"
           "Default Colour mode %s\n",
           dbLeakyGetObjectName(*default_gc),
           dbLeakyGetObjectName(GetColourMode())
         );

  fprintf(out, "Access Mode: ");
  /*switch(access_mode){
    case amReadOnly: fprintf(out, "Read Only\n"); break;
    case amWriteOnly: fprintf(out, "Write Only\n"); break;
    case amReadWrite: fprintf(out, "Read Write\n"); break;
  }*/
}

bool ppgDevice::dbIntegrityOk()const
{
  char o_name[100];
  if(! default_gc){
    ppWarning("Device %s, has no default GC\n", 
               dbGetObjectName(o_name, sizeof(o_name))
             );
    return false;
  }
  if(! &GetColourMode()){
    ppWarning("Device %s, has no default colour mode\n" ,
               dbGetObjectName(o_name, sizeof(o_name))
             );
    return false;
  }

  return true;
}
#endif

