/*************************************************************
   This .cc file is a "target" for the library.  We must be
   the library must be able to make this file work with only
   trivial changes.
*************************/

#include <PenguinPlay/Penguin2d.h>     
#include <iostream.h>
#include <stdio.h>

/********************************
  Semantic point.  A method called GetXXXXX which returns a pointer,
  simply returns a pointer to an object owned by someone else.
  A method called NewXXXXXX will however create a new object,
  which must be deallocated, probably with "delete".
  (In fact the PPlay API will return references, but above the semantics
  still applies, including the need to "delte").

  If XXXXXXXXX is link counted the NewXXXXXXXX will set
  the link count to be 1 and deallocation is done with
  "Unlink".
************/


int main(int argc, char **argv)
{

  /*
   *  Initialize the library.
   */
  ppInit(&argc, argv);
  ppInitGraphics();


  /*
   *  Get some improtant graphics objects set up.
   */
   
  ppgDevice& TheDevice = ppgNewDevice();
  
  //we could specify the mode in here using getsets, 
  //but we'll just use the defaults.
  //FIX: think about the evil of GETSETs.
  
  try{ TheDevice.SetMode(*new ppgMode());}
  catch (ppgDevice::eNoMode ex) {
    cout << ex.Message() << '\n';
    exit(1);
  } 
  ppgSurface& MainSurface = TheDevice.GetMainSurface();
  ppgGC& TheGC = TheDevice.GetDefaultGC();
  TheGC.SetSurface(MainSurface);
    //FIX: hmmm, should this happen automatically by default?
    //after all, the lib should have some sugar.


  /*
   *  Set up an image to blit.
   */
   ppgRGBAPixel buf[10][10];
   memset(buf, ~0, sizeof(buf)); 
   for(int i=0 ; i < 10; i+=2)
     for(int j=0 ; j < 10; j+=2)
	   buf[i][j]=0;

  /*
   *  Start drawing.
   */
  //TheGC.SetForeground((ppgPixel)~0); //superflous now, since it is default.
  TheGC.DrawHLine(5, 5, 20);
  TheGC.Blit((ppgRGBAPixel*)buf, 10*sizeof(ppgRGBAPixel), 7, 2, 10, 10);
  TheGC.PixBlit
    ((ppgRGBAPixel)~0, 10, 10);


  /*
   * Hmm, welll.
   */
  TheDevice.Flush();


  #ifdef PP_DEBUG
  ppBase::dbDumpAll(stderr);
  #endif //PP_DEBUG
  sleep(3);

  delete &TheDevice;

  //ppShutDown();
}
