/*************************************************************
   This .cc file is a "target" for the library.  We must be
   the library must be able to make this file work with only
   trivial changes.
*************************/

#include <PenguinPlay/Penguin2d.h>     
#include <iostream.h>
#include <stdio.h>

/********************************
  Semantic point.  A method called GetXXXXX which returns a pointer,
  simply returns a pointer to an object owned by someone else.
  A method called NewXXXXXX will however create a new object,
  which must be deallocated, probably with "delete".

  If XXXXXXXXX is link counted the NewXXXXXXXX will set
  the link count to be 1 and deallocation is done with
  "Unlink".
************/


int main(int argc, char **argv)
{

  /*
   *  Initialize the library.
   */
  ppInit(&argc, argv);
  ppInitGraphics();


  /*
   *  Get some improtant graphics objects set up.
   */
   
  ppgDisplay& TheDisplay = ppgNewDisplay();
  
  //we could specify the mode in here using getsets, 
  //but we'll just use the defaults.
  
  try{ TheDisplay.SetMode();}
  catch (ppgDisplay::eNoMode ex) {
    cout << ex.Message() << '\n';
  } 
  ppgOutputSurface& MainSurface = TheDisplay.GetMainSurface();
  ppgGC& TheGC = MainSurface.GetClass().GetDefaultGC();
  TheGC.SetSurface(MainSurface);


  /*
   *  Set up an image to blit.
   */
   ppgRGBAPixel buf[10][10];
   memset(buf, ~0, sizeof(buf)); 
   for(int i=0 ; i < 10; i+=2)
     for(int j=0 ; j < 10; j+=2)
	   buf[i][j]=0;

  /*
   *  Start drawing.
   */
  //TheGC.SetForeground((ppgPixel)~0);
  TheGC.DrawHLine(5, 5, 20);
  TheGC.BlitRGBA((ppgRGBAPixel*)buf, 10*sizeof(ppgRGBAPixel), 7, 2, 10, 10);
  TheGC.PixBlitRGBA((ppgRGBAPixel)~0, 10, 10);


  /*
   * Hmm, welll.
   */
  TheDisplay.Flush();


  #ifdef PP_DEBUG
  ppBase::dbDumpAll(stderr);
  #endif //PP_DEBUG
  sleep(3);

  delete &TheDisplay;

  //ppShutDown();
}
