/*************************************************************
   This .cc file is a "target" for the library.  We must be
   the library must be able to make this file work with only
   trivial changes.
*************************/

#include <PenguinGraphics.h>     



/********************************
  Semantic point.  A method called GetXXXXX which returns a pointer,
  simply returns a pointer to an object owned by someone else.
  A method called NewXXXXXX will however create a new object,
  which must be deallocated, probably with "delete".

  If XXXXXXXXX is link counted the NewXXXXXXXX will set
  the link count to be 1 and deallocation is done with
  "Unlink".
************/


int main(int argc, char **argv)
{

	ppInit(&argc, argv);


	ppInitGraphics();

	/*
	  This constructor opens the display in a graphics node 
	  close to the hint I just gave it.  This is just the 'quick&easy'
	  way, you can do proper mode negoitiation.
	*/	
	ppgDoubleBufferedDisplay Display;


	Display.SetMode(
		16,				//16bpp
		100, 100		//100x100 real & virtual size	
	); 

	/*I should be checking what mode I really got here.  Bugger that.*/


	/****
	   If this wasn't a double buffered display, the surface
	   here would be the visible viewport, as it is, it
	   represents the backbuffer.

	   The surface provided by GetMainSurface is always
	   the same, but some of the state info such as the
	   actual buffer pointer could change on buffer swap.
	*****/
	ppgSurface &out = Display.GetMainSurface();
	ppgColourMode &visual = out.GetClass().GetColourMode();


	ppgGC &GC = out.GetClass().GetDefaultGC();
	GC.SetSurface(out); //FIX:    this is clunky.
	GC.Clear();
	
	ppgPixel pix;
	pix.UInt=0x0000ffff; //FIX.  Make this neater?
	GC.SetPixel(pix);
	GC.DrawLine(10, 10, 30, 30);


	/*Actually displays the contents of the buffer.*/
	Display.Flush();
	

	/*
	  The display needs to be shut down before the rest of PenguinPlay,
	  I suppose
	*/

	sleep(3);

    #ifdef PP_DEBUG
	ppBase::dbDumpAll(stderr);
	#endif

	printf("\n\n\nCHOMP CHOMP\n");

	//ppShutDown();
}
