/**********************************************************
	ppgSurface.h: Defines drawing surfaces.

	Part of the PenguinPlay - 2d library.  Defines Drawing Commands
	for use in this library.  Please LICENSE.TXT supplied with
	this library.

	Copyright (C) 	Adrian Ratnpala 1998.
**********************************************************/


#ifndef _ppgLinear_h
#define _ppgLinear_h

#include <ppgCommon.h>
#include <ppgColour.h>
#include <ppgSurface.h>
#include <ppgSurfaceClass.h>

class ppgLinearSurface;

/**
   This gives us info about the layout of the block. 
**/
class ppgLinearSurfaceClass : public ppgSurfaceClass {

  ppuInt access_width;
  ppuInt access_align;
  
  /*FIX: bit shifting?  Or does that go in ColourMode?*/


  public:

  _PP_GETSET(AccessWidth, access_width, ppuInt);
  _PP_GETSET(AccessAlign, access_align, ppuInt);

  virtual ppgGC& NewGC()const;

  #ifdef PP_DEBUG
  virtual char* dbGetClassName()const{return "LINEAR_BLOCK_CLASS";}
  #endif
};



/**
  This surface type represents a block of pixels represented in a sane
  manner in memory.
**/
class ppgLinearSurface : public ppgMemSurface {

    int scanline_skip;

  public:

    //distance in bytes between one scanline and the next.
    _PP_GETSET(ScanlineSkip, scanline_skip, int);


    ppgLinearSurface(const ppgSurfaceClass& cls, 
                     void* ptr, ppgCoord w, ppgCoord h,
                     int stride=0
                    ):ppgMemSurface(cls, ptr, w, h)
    {
      if(stride) SetScanlineSkip(stride);
      else SetScanlineSkip(cls.GetColourMode().GetDepth()*w/8);
    }
                    
       
    #ifdef PP_DEBUG
    virtual char* dbGetClassName()const{return "LINEAR_BLOCK";}
    #endif
};
#endif // ppgLinear_h
