/************************************************************************
    ppgGC_types.inc:  Types used to store GC state info.


	Really this file is part of ppgGC.h, but it's in a seperate file for 
	neatness' sake.


    Part of the PenguinPlay 2d library.  Please see LICENSE.TXT supplied
    with this library for copyright details.

    Copyright (C)    Adrian Ratnapala 1998.


    $Author: raka $
    $Date: 1998/08/14 21:02:06 $
    $Revision: 1.1 $
************************************************************************/


#ifndef _in_ppgGC_h
  #error This file must be included from ppgGC.h!
#endif



//:  How transparency is handled (if at all).
enum TransparencyMode{
  tmOpaque, 
  tmAlpha, 
  tmThreshholdAlpha,   /*Transparent for Alpha < Threshold*/
  tmTransparentColour, /*There is a special transparent colour*/
  tmNumVals
} ;

  
//:  What kind of (linear) transomfation is applied (if any).
// Do we transform ops acording to an arbitrary matrix, just scale
// them, or leave them alone?
enum  TransformMode {xmIdentity, xmScale, xmArbitrary, xmNumVals};


//: A transformation.
//Represents a (2x2?) transformtion matrix.  We can do matrix arithmetic.
//This should probably just be typedef from another type in the 
//maths section.
class Transformation{
  // This class is currently unimplemented.
};
  

//: All our wonderful ways of doing antialiasing.
enum  AntialiasMode { amNone, amNumVals};



//:  Drawing style for lines.
enum LineStyle {
  lsNone,             /*invisible lines.*/
  lsSolid,            /*solid lines in current current ?foreground? colour.*/
  lsPixmap,           /*line style is a repeating 1d pixmap*/
  lsStretchedPixmap,  /*line is a single scaled 1d pixmap*/
  lsBitmap,           /*line style is a repeating 1d bitmap*/
  lsStretchedBitmap,  /*line is a single scaled 1d bitmap*/
  lsNumVals
};



//:  How ngons etc. are filled.
enum FillStyle {
  fsNone,              /*empty.  Tranparent innards.*/
  fsSolid,             /*solid block in current foreground colour.*/
  fsPixmapStipple,     /*pixmap based stipple*/
  fsBitmapStipple,
  fsNumVals
};
