/************************************************************************
    ppgCppDefs.inc:  Some private macros used by parts of pg2d.


    Part of the PenguinPlay 2d library.  Please see LICENSE.TXT supplied
    with this library for copyright details.

    Copyright (C)    Adrian Ratnapala 1998.


    $Author: raka $
    $Date: 1998/11/25 10:05:55 $
    $Revision: 1.2 $
************************************************************************/


/*
 * Here are some stupid cpp macros which _I_(raka) think improve
 * the code quality of pg2d.  I don't know if anyone else would
 * agree, but then _I_ maintain the code, so I'm the only one who
 * cares.
 */

//: Coords reprsenting the position a drawing op's output.
#define OUT_COORDS    ppgCoord out_x, ppgCoord out_y
#define O_CRDS out_x, out_y

//: Coords representing the posistion of a drawing op's input.
#define IN_COORDS     ppgCoord in_x, ppgCoord in_y
#define I_CRDS in_x, in_y

//: Geometry of the region over which an op, well operates. 
#define SIZE_COORDS   ppgCoord w, ppgCoord h
#define S_CRDS  w, h

//: Args which a LOT of drawing seem to have in common.
#define COORDS OUT_COORDS, IN_COORDS, SIZE_COORDS
#define CRDS O_CRDS I_CRDS, S_CRDS


//: Information defining a buffer of pixels.
#define BUFF_INFO(TYPE) TYPE* in, int scanline_skip
#define B_INFO in, scanline_skip

//: All drawing ops MUST take these args.
#define COMMON_ARGS ppgGC& gc, ppgSurface& out
