/************************************************************************
    ppgCommon.h:  Defines all the basics for pg2d.


    Part of the PenguinPlay 2d library.  Please see LICENSE.TXT supplied
    with this library for copyright details.

    Copyright (C)    Adrian Ratnapala 1998.


    $Author: raka $
    $Date: 1998/11/25 10:05:53 $
    $Revision: 1.5 $
************************************************************************/

#ifndef _ppgCommon_h
#define _ppgCommon_h

#include <PenguinPlay/PenguinPlay.h>
#include <PenguinPlay/LayerO.h>

/****************************************************
  Types, macros, constants etc.
****************************************************/

//: An ON SCREEN coordinate.
typedef int    ppgCoord ;    


//: Self expanatory.  (FIX: Probably should be renamed).
typedef struct {
  ppgCoord x,y;
} ppgPoint;


/***
  Some macros for things I really got tired of typing.
  It harms readability in some ways but helps it in
  others.  (Clutter is as bad as terseness).
***/

//: Saves me typing.
#define _PP_POINT_COORDS ppgCoord x, ppgCoord y
//: Saves me typing.
#define _PP_BOX_COORDS ppgCoord x, ppgCoord y, ppgCoord w, ppgCoord h






/************************************************************
  Actuall interface functions.
***********************************************************/

//: Initialize pg2d.  FIX: should be renamed.
void ppInitGraphics();
/*ppCloseGraphics(); This could be internal*/


class ppgDisplay;
//: Create a new display.  
//  FIX:  Maybe this should be a static member of ppgDisplay
//  But _I_ think that sort of thing is just Java silliness with
//  no benefit beyond extra verbosity.
//  FIX: Either way, this should go in ppgDisplay.h instead of here
//  (or was there some reason for me to put it here in the first 
//  place?).
//  
//  For now the name string is ignored, but think X.
ppgDisplay& ppgNewDisplay(char* name = NULL);


#endif /*_ppgCommon_h*/
