/************************************************************************
    ppgSurface.h:  Defines ppgSurface, ppgMemSurface.


    ppgSurface:
        A rectangle of pixels which can be drawn into.

    ppgMemSurface:
        A surface who's pixels are in user visible memory.

    Part of the PenguinPlay 2d library.  Please see LICENSE.TXT supplied
    with this library for copyright details.

    Copyright (C)    Adrian Ratnapala 1998.


    $Author: raka $
    $Date: 1998/11/25 10:06:17 $
    $Revision: 1.3 $
************************************************************************/


#ifndef _ppgSurface_h
#define _ppgSurface_h

#include "ppgCommon.h"
#include <PenguinPlay/ppgDevice.h>

class ppgGC;

//: Surfaces you can draw into.  (Unless you can't)
//  This defines all those things which surfaces have in common.
class ppgSurface : public ppBase {

    ppgCoord width, height;
    ppgDevice* dev;


  public:

    
    _PP_GETSET_REF(Device, dev, ppgDevice);
        // FIX: deprecate this.  Actually get rid of it.
	// hopefully that should be just a matter of 
	// commenting this out and fixing the resuting compiler
	// errors.  Hopefully.

    ppgSurface():dev(NULL){}
    ppgSurface(ppgDevice& _dev, _PP_POINT_COORDS)
     : width(x), height(y){ SetDevice(_dev); }
    ~ppgSurface(){}
    
    _PP_GETSET(Width , width , ppgCoord); //: Width of surface in pixels.
    _PP_GETSET(Height, height, ppgCoord); //: Height of surface in pixels. 


    #ifdef PP_DEBUG
    virtual char* dbGetClassName()const{return "SURFACE";}
    #endif
};




//: This is any surface who's pixels are a user visible bunch of bytes.
//  Not much to this class really.  Just asserting the
//  fact that we do indeed have a memory block involved.
//
//  The memory block WILL NOT be deallocated on destruction.
class ppgMemSurface :  public ppgSurface {

    void* mem_block;

  public:

    ppgMemSurface():mem_block(NULL){};
    ppgMemSurface(ppgDevice& _dev, void* ptr, _PP_POINT_COORDS)
      : 
        ppgSurface(_dev, x, y),
	    mem_block(ptr)
      {};

    _PP_GETSET(MemBlock, mem_block, void*);
};


//: Surface impemented over some other opaque graphics system.
//  Stupid base class for things like ppgGGISurface
//  and other things implemented on top of other 
//  graphics systems.  Knows where it's origin is relative
//  to whatever.
class ppgOutputSurface :  public ppgSurface {

  ppgCoord x,y;

  public:


  ppgOutputSurface():x(0),y(0){};
  ppgOutputSurface(ppgDevice& _dev, 
                   ppgCoord _x, ppgCoord _y, 
                   ppgCoord w, ppgCoord h
                  ) : 
    ppgSurface(_dev, w, h),
    x(_x), y(_y)
    {};

  _PP_GETSET (XPos, x, ppgCoord);
  _PP_GETSET (YPos, y, ppgCoord);
  //_PP_GETSET(MemBlock, mem_block, void*);
};
#endif // ppgSurface_h
