/************************************************************************
    ppgPixel.h:  Defines ppgPixel.


    ppgPixel:
        An opaque datum representing a single pixel.


    Part of the PenguinPlay 2d library.  Please see LICENSE.TXT supplied
    with this library for copyright details.

    Copyright (C)    Adrian Ratnapala 1998.


    $Author: raka $
    $Date: 1998/08/21 06:21:10 $
    $Revision: 1.2 $
************************************************************************/

#ifndef _ppgPixel_h
#define _ppgPixel_h

#include "ppgCommon.h"



//: Opaque pixel datum.
//
//
//  Minimal data type representing just the 
//  colour data and not its meaning.
//  This type is exactly 32 bits big.
//
//  FIX: perhaps this should just be a simple uint.  (not even uInt32.)
//
typedef ppu32 ppgPixel;

//: Specificlly RGBA version of ppgPixel.  No real typesafety, but...
typedef ppgPixel ppgRGBAPixel;

//: Specificlly 8r8b8g8a version of ppgPixel.  No real typesafety, but...
typedef ppgPixel ppgAbsPixel;

#endif //_ppgPixel_h
