/************************************************************************
    ppgMode.h:  Defines ppgMode.


    ppgMode:
        Abstract representation of a video mode.


    Part of the PenguinPlay 2d library.  Please see LICENSE.TXT supplied
    with this library for copyright details.

    Copyright (C)    Adrian Ratnapala 1998.


    $Author: raka $
    $Date: 1998/10/02 06:00:32 $
    $Revision: 1.4 $
************************************************************************/

#ifndef _ppgMode_h
#define _ppgMode_h

#include "ppgCommon.h"


//: A video mode description.
//
//  This class is a utility class for things like video mode negotiation 
//  description.
//
class ppgMode : ppBase {

  //FIX: we also need stuff for things like RGB vs. CI etc. etc.


  ppgCoord width, height,   //FIX: Make these shorts?  Not important.
  virt_width, virt_height,
  phys_width, phys_height;  //milimeters?

  int colour_depth;
  int bytes_pp;

  // now there was some reason why I didn't just hardcode -1
  // in, but I can't remember what it is.  Oh well, I;ve done
  // the work now.
  const ppgCoord unset_width      = -1, unset_height      = -1,
	         unset_virt_width = -1, unset_virt_height = -1,
	         unset_phys_width = -1, unset_phys_height = -1;
  const int unset_colour_depth = -1;
  const int unset_bytes_pp = -1;

		 
  public:

  /*
   * Administrivia.
   */

  /*FIX: we want a constructor that takes mode related arguments*/
  /*FIX: how to handle defaults?*/
  ppgMode();

  ~ppgMode();

  /*
   *  Mode related variables.
   *
   *  Setting these does NOT (necassarily) report an error if the
   *  vals are invalid.
   */

  _PP_GETSET(Width, width, ppgCoord);   //: Width of user visible area.
  GetUnsetWidth(){return unset_width;}
  
  _PP_GETSET(Height, height, ppgCoord); //: Height of user visible area.
  GetUnsetHeight(){return unset_height;}

  //virtual size  (net neccassarily all visible)
  _PP_GETSET(VirtWidth, virt_width, ppgCoord);
  GetUnsetVirtWidth(){return unset_virt_width;}
  //:total width(maybe part hidden).
  
  _PP_GETSET(VirtHeight, virt_height, ppgCoord);
  GetUnsetVirtHeight(){return unset_virt_height;}
  //:total height (maybe part hidden).

  //phyiscal size (visible) in mm (i.e monitor dependent).
  //_PP_GETSET(PhysWidth, int);
  //_PP_GETSET(PhysHeight, int);

  //depth
  _PP_GETSET(ColourDepth, colour_depth, int); //: Signficant bits per pixel.
  GetUnsetColourDepth(){return unset_colour_depth;}
  
  _PP_GETSET(BytesPP, bytes_pp, int);         //: Bytes per pixel.
  GetUnsetBytesPP(){return unset_bytes_pp;}
};


#endif // ppgMode_h
