/************************************************************************
    ppgLinearSurface.h:  Defines ppgLinearSurface.


    ppgLinearSurface:
        A surface representing a linear memory buffer.


    Part of the PenguinPlay 2d library.  Please see LICENSE.TXT supplied
    with this library for copyright details.

    Copyright (C)    Adrian Ratnapala 1998.


    $Author: raka $
    $Date: 1998/11/25 10:06:11 $
    $Revision: 1.4 $
************************************************************************/


#ifndef _ppgLinearSurface_h
#define _ppgLinearSurface_h

#include "ppgCommon.h"
#include <PenguinPlay/ppgSurface.h>

class ppgLinearDevice;


//: A block of pixels represened sanely in memroy.
//
// This can represent any block of pixels where each span is
// a linear blocks of memory, and each span is equally spaced 
// in memory.
//
// It could be in main or video memory.  Destroying the ppgLinearSurface
// DOES NOT free the associated memory.
//
class ppgLinearSurface : public ppgMemSurface {

    int scanline_skip;

  public:



    ppgLinearSurface(ppgLinearDevice& cls, 
                     void* ptr, ppgCoord w, ppgCoord h,
                     int stride=0
                    );
                    
    _PP_GETSET(ScanlineSkip, scanline_skip, int);
    //: distance in bytes between one scanline and the next.
       
    #ifdef PP_DEBUG
    virtual char* dbGetClassName()const{return "LINEAR_BLOCK";}
    #endif
};
#endif // ppgLinearSurface_h
