/************************************************************************
    ppgLinearCommands.h:  Defines ppgLinearCommands.


    ppgLinearCommands:
        Holds commands for drawing into linear memory buffers.


    Part of the PenguinPlay 2d library.  Please see LICENSE.TXT supplied
    with this library for copyright details.

    Copyright (C)    Adrian Ratnapala 1998.


    $Author: raka $
    $Date: 1998/11/25 10:06:09 $
    $Revision: 1.3 $
************************************************************************/




#ifndef _ppgLinearCommands_h
#define _ppgLinearCommands_h

#include "ppgCommon.h"
#include "ppgGC.h"

#include "ppgCppDefs.inc"
#undef COMMON_ARGS
#define COMMON_ARGS ppgGC& gc, ppgLinearSurface& out



//: Holder for command handlers which work on ppgLinearSurfaces.
//  These functions are defined outside ppgLinearSurface because
//  the draw commands are not strictly part of a ppgSurface.
//  (After all the user is allowed to change them at will).
//  
//  Really these are freestanding functions, but I have made
//  them static functions of a class for neatness (g++ should
//  support namespaces!).
//
class ppgLinearDrawCmds{

  public:

    static void PixBlitRaw8(COMMON_ARGS, ppgPixel in, _PP_POINT_COORDS);
      //: 8-bit putpixel
    static void PixBlitRaw16(COMMON_ARGS, ppgPixel in, _PP_POINT_COORDS);
      //: 16-bit putpixel
    static void PixBlitRaw32(COMMON_ARGS, ppgPixel in, _PP_POINT_COORDS);
      //: 32-bit putpixel

    static void DrawLine8(COMMON_ARGS, _PP_BOX_COORDS); //:8 bit drawline.
    static void DrawLine16(COMMON_ARGS, _PP_BOX_COORDS); //:16 bit drawline.
    static void DrawLine32(COMMON_ARGS, _PP_BOX_COORDS); //: 32 bit drawline.
    
    static void Clear(COMMON_ARGS);  //: Blank out the screen.
    
    static void Empty(COMMON_ARGS);  //: This command does nothing.
	//FIX: Delete this
};


#include "ppgCppUndefs.inc"
#endif // ppgLinearCommands_h
