/************************************************************************
    ppgGGISurface.h:  Defines ppgGGISurface.


    ppgGGISurface:
        Represents part of a GGI visual.


    Part of the PenguinPlay 2d library.  Please see LICENSE.TXT supplied
    with this library for copyright details.

    Copyright (C)    Adrian Ratnapala 1998.


    $Author: raka $
    $Date: 1998/11/25 10:06:07 $
    $Revision: 1.3 $
************************************************************************/


#ifndef _ppgGGISurface_h
#define _ppgGGISurface_h

#include "ppgCommon.h"
#include <PenguinPlay/ppgGGIDevice.h>
#include <PenguinPlay/ppgSurface.h>

#include <ggi/ggi.h>

class ppgGGIDevice;

//: GGI based surface class.
//  This surface represents a region of a GGI visual.
// I suppose we should hide this class as much as possible.
class ppgGGISurface : public ppgOutputSurface {
  public:

  ppgGGISurface(ppgGGIDevice& dev, 
                ppgCoord x, ppgCoord y,  //geometry
                ppgCoord w, ppgCoord h
               );

  //gii_visual_t GetGGIVisual(){
  //  return ((ppgGGIDevice&)GetDevice()).GetGGIVisual();
  //}
  //: Get the GGI visual which this surface represents part of.


  #ifdef PP_DEBUG
  virtual char* dbGetClassName()const{return "GGI_SURF";}
  #endif
};
#endif // ppgGGISurface_h
