/************************************************************************
    ppgGGIDevice.h:  Defines ppgGGIDevice.


    ppgGGIDevice:
        Represents a GGI based display device.


    Part of the PenguinPlay 2d library.  Please see LICENSE.TXT supplied
    with this library for copyright details.

    Copyright (C)    Adrian Ratnapala 1998.


    $Author: raka $
    $Date: 1998/11/25 10:06:05 $
    $Revision: 1.1 $
************************************************************************/


#ifndef _ppgGGIDevice_h
#define _ppgGGIDevice_h

#include "ppgCommon.h"
#include "PenguinPlay/ppgDevice.h"

#include <ggi/ggi.h>



//: GGI based user visible display.
//  This class handles things like video mode negotiation and 
//  setting, buffer swapping etc.
//  See ppgDevice for most member descriptions.
class ppgGGIDevice : public ppgDevice {

  ggi_visual_t ggi_visual;
 
  int      depth;
  int      bpp;

  
  virtual void InitializeGC(ppgGC& gc) const;

  public:

  /*
   * Administrivia.
   */

  /*FIX: perhaps a constructor that takes mode related arguments?*/
  ppgGGIDevice();
  ppgGGIDevice(ppgMode& start_mode){SetMode(start_mode);}

  virtual ~ppgGGIDevice();

  /*
   *  Actual mode negoitiation and setting.
   */
  
  //see if the currently stored mode is acceptable.  If not,
  //change it.

  virtual bool QueryMode(ppgMode& mode);
  //: change the currently selected mode into something that works.

  virtual void SetMode(ppgMode& mode);
  //: try to set the mode.  


  /*
   * Actual library objects which we supply.
   */
  ggi_visual_t GetGGIVisual(){return ggi_visual;}

  /*
   *  Makes sure what's on screen is what you think it is.
   */
  virtual void Flush(); //: Front end to ggiFlush.

  virtual void BeginDraw(ppgGC&);
  virtual void EndDraw();

  
  /*
   * Into the debugging gutter.
   */
  #ifdef PP_DEBUG
  virtual char* dbGetClassName()const{return "DISPLAY";}
  virtual char* dbGetDump(FILE* out)const{return "DISPLAY";}
  #endif //PP_DEBUG
};




#endif // ppgGGIDevice_h
