/************************************************************************
    ppgGGICommands.h:  Defines ppgGGICommands.


    ppgGGICommands:
        Holds commands for drawing into GGI surfaces.


    Part of the PenguinPlay 2d library.  Please see LICENSE.TXT supplied
    with this library for copyright details.

    Copyright (C)    Adrian Ratnapala 1998.


    $Author: raka $
    $Date: 1998/11/25 10:06:04 $
    $Revision: 1.3 $
************************************************************************/



#ifndef _ppgGGICommands_h
#define _ppgGGICommands_h

#include "ppgCommon.h"
#include <PenguinPlay/ppgPixel.h>


class ppgGC;
class ppgGGISurface;


//: A nice holder for command handlers for GGI visuals.
// Really these handlers are freestanding functions, but I have made
// them static functions of a class for neatness (g++ should
// support namespaces!).
//
class ppgGGIDrawCmds{

  public:
 
#include "ppgCppDefs.inc"

  #define HAND(NAME) static void NAME(COMMON_ARGS
  #define DNAH )

  HAND(PixBlit), ppgRGBAPixel in, _PP_POINT_COORDS DNAH;

  HAND(SetForeground), ppgPixel DNAH;
  HAND(SetBackground), ppgPixel DNAH;
  
  HAND(Clear) DNAH;
  
  HAND(DrawHLine), ppgCoord x, ppgCoord y, ppgCoord len DNAH;

  #undef HAND
  #undef DNAH
  
#include "ppgCppUndefs.inc"

};


#endif // ppgGGICommands_h
