/************************************************************************
    ppgDevice.h:  Defines ppgDevice.


    ppgDevice:
        Represents the environment in which a group of compatible surface
	exists. FIX: that is a _really_ vague description.  Not goud
	when you can't describe what one of the classes in your API does.


    Part of the PenguinPlay 2d library.  Please see LICENSE.TXT supplied
    with this library for copyright details.

    Copyright (C)    Adrian Ratnapala 1998.


    $Author: raka $
    $Date: 1998/11/25 10:05:59 $
    $Revision: 1.1 $
************************************************************************/



#ifndef _ppgSurfaceClass_h
#define _ppgSurfaceClass_h

#include "ppgCommon.h"
#include <PenguinPlay/ppgColour.h>
#include <PenguinPlay/Exceptions.h>

class ppgGC;
class ppgSurface;
class ppgColourMode;
class ppgDevice;
class ppgMode;


//HELP: Is this buisiness of having DeviceName strings correct?
//FIX: should this be a static member?  I don't think so but...
ppgDevice& ppgNewDevice(const char* DeviceName = 0);
//ppgDevice& ppgNewDevice(char* DeviceName = 0, mode parameters);


class ppgDevice : public ppBase { 

  public:

  private:
  
  //put flags all up here, so the compiler can pack them.  
  mutable bool default_gc_exists:1;
  
  mutable ppgGC* default_gc;
  ppgColourMode* colour_mode;
  ppgSurface* main_surface;
 
  
  public:

  /*Administrivia*/
  
  ppgDevice();
  ~ppgDevice();

  #ifdef PP_DEBUG
  virtual char* dbGetClassName()const{return "SURFACE_CLASS";}
  virtual void dbDump(FILE* out)const;
  virtual bool dbIntegrityOk()const;
  #endif

  /*Info Getting*/
  _PP_GETSET_REF(ColourMode, colour_mode, ppgColourMode);
  _PP_GETSET_REF(MainSurface, main_surface, ppgSurface); 
 

  /*Mode Negotitation*/

  class eNoMode : ppException {
    char* msg;
  
    public:
 
    eNoMode(char* _msg) : msg(_msg) {}
    virtual char* Message(); 
  };
  //: What happens if negotiations break down.

  
  virtual bool QueryMode(ppgMode& mode) = 0;
  virtual void SetMode(ppgMode& mode) = 0;
  //void SetMode(mode parameters);
  


  /*GC Handling*/
  ppgGC& NewGC()const;  //: Create a new, compatible GC.

  
  ppgGC& GetDefaultGC()const;       //: Get a (possibly recycled) GC.
  void SetDefaultGC(ppgGC&);        //: Change the default.
  ppgGC& TakeDefaultGC();
 

  virtual void BeginDraw(ppgGC& gc)=0;
  //: Focus gc onto this display.  
  //  This must be called before drawing into any surface on this display.
  
  virtual void EndDraw()=0;
  //: The mate to BeginDraw()
  //  As far as I can tell this is a no op.  I just feel it should exist,
  //  just in case.



  /*Miscilaneus*/
  virtual void Flush()=0;
  //: Syncs what has been drawn into the display with what is on screen.
  //  NOTE: THIS IS NOT (necassarily) A BUFFER SWAP!  It is meant for 
  //  flushing queues (be they hardware or X protocol).


  
  protected:
  
  virtual void InitializeGC(ppgGC& GC)const = 0;
};


#endif // ppgDisplay_h
