/** 
 ** RESIZE.C 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/


#if defined(__GNUC__) && !defined(near)
# define near
# define far
# define huge
#endif

#define UCP unsigned char far *

void resize(UCP src,int soff,int oldx,int oldy,UCP dst,int doff,int newx,int newy)
{
	UCP newpt;
	UCP oldpt;
	int pt1,pt2;
	int sum,fac;
	int xx,yy;
	int oo,nn;

	if(oldx < newx) {
	    oo = oldx - 1;
	    nn = newx - 1;
	    for(yy = 0; yy < oldy; yy++) {
		oldpt = src + yy*soff + oo;
		newpt = dst + yy*doff + nn;
		pt2 = *oldpt;
		pt1 = *--oldpt;
		*newpt = pt2;
		xx = fac = nn;
		while(--xx > 0) {
		    if((fac -= oo) < 0) {
			fac += nn;
			pt2 = pt1;
			pt1 = *--oldpt;
		    }
		    *--newpt = (pt1*(nn-fac) + pt2*fac) / nn;
		}
		*--newpt = pt1;
	    }
	    src  = dst;
	    soff = doff;
	}
	if(oldx > newx) {
	    for(yy = 0; yy < oldy; yy++) {
		oldpt = src + yy*soff;
		newpt = dst + yy*doff;
		xx = nn = newx;
		while(--xx >= 0) {
		    sum = 0;
		    oo  = oldx;
		    while(oo > 0) {
			if(nn == 0) { nn = newx; oldpt++; }
			if((fac = nn) > oo) fac = oo;
			sum += fac * (*oldpt);
			nn -= fac;
			oo -= fac;
		    }
		    *newpt++ = sum / oldx;
		}
	    }
	    src  = dst;
	    soff = doff;
	}
	if(oldy < newy) {
	    nn = newy - 1;
	    oo = oldy - 1;
	    src += oo*soff;
	    dst += nn*doff;
	    for(xx = 0; xx < newx; xx++) {
		oldpt = src + xx;
		newpt = dst + xx;
		fac = yy = nn;
		pt2 = *oldpt;
		pt1 = *(oldpt -= soff);
		*newpt = pt2;
		while(--yy > 0) {
		    if((fac -= oo) < 0) {
			fac += nn;
			pt2 = pt1;
			pt1 = *(oldpt -= soff);
		    }
		    *(newpt -= doff) = (pt1*(nn-fac) + pt2*fac) / nn;
		}
		*(newpt -= doff) = pt1;
	    }
	}
	if(oldy > newy) {
	    for(xx = 0; xx < newx; xx++) {
		oldpt = src + xx;
		newpt = dst + xx;
		yy = nn = newy;
		while(--yy >= 0) {
		    sum = 0;
		    oo  = oldy;
		    while(oo > 0) {
			if(nn == 0) { nn = newy; oldpt += soff; }
			if((fac = nn) > oo) fac = oo;
			sum += fac * (*oldpt);
			nn -= fac;
			oo -= fac;
		    }
		    *newpt = sum / oldy;
		    newpt += doff;
		}
	    }
	}
}

